/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import me.gb2022.commons.reflect.AutoRegister;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.quark.security.WESessionTrackService;
import org.atcraftmc.quark.security.event.WESessionSelectEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.tbstcraft.quark.data.PlayerDataService;
import org.tbstcraft.quark.data.storage.DataEntry;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.foundation.platform.Players;
import org.tbstcraft.quark.foundation.region.SimpleRegion;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.0.0")
@AutoRegister(value={"qb:el"})
@CommandProvider(value={WESessionRenderCommand.class})
public final class WESessionRenderer
extends PackageModule {
    private final Map<Player, RenderMode> modes = new HashMap<Player, RenderMode>();

    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requirePlugin((String)"WorldEdit");
    }

    public void enable() {
        TaskService.global().timer("quark:we-renderer:main", 0L, 5L, () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (this.mode(p) != RenderMode.PERSISTENT) continue;
                this.draw(p);
            }
        });
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.modes.put(p, this.load(p));
        }
    }

    public void disable() {
        TaskService.global().cancel("quark:we-renderer:main");
    }

    @EventHandler
    public void onSelectionUpdate(WESessionSelectEvent event) {
        if (this.mode(event.getPlayer()) != RenderMode.UPDATE) {
            return;
        }
        this.render(event.getPlayer());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.modes.put(event.getPlayer(), this.load(event.getPlayer()));
    }

    private RenderMode mode(Player player) {
        return this.modes.computeIfAbsent(player, k -> RenderMode.UPDATE);
    }

    private void draw(Player p) {
        SimpleRegion r = WESessionTrackService.getRegion(p);
        if (r == null) {
            return;
        }
        Players.show3DBox((Player)p, (Location)r.getPoint0(), (Location)r.getPoint1());
    }

    private void render(Player p) {
        AtomicInteger t = new AtomicInteger();
        TaskService.global().timer(0L, 5L, ctx -> {
            t.addAndGet(5);
            if (t.get() > 25) {
                ctx.cancel();
            }
            this.draw(p);
        });
    }

    private void save(Player player) {
        DataEntry entry = PlayerDataService.get((Player)player);
        entry.setEnum("we_session:render_mode", (Enum)this.modes.get(player));
        entry.save();
    }

    private RenderMode load(Player player) {
        DataEntry entry = PlayerDataService.get((Player)player);
        if (!entry.hasKey("we_session:render_mode")) {
            return RenderMode.UPDATE;
        }
        return (RenderMode)entry.getEnum("we_session:render_mode", RenderMode.class);
    }

    static enum RenderMode {
        NEVER,
        UPDATE,
        PERSISTENT;


        static RenderMode of(String id) {
            return switch (id) {
                case "update" -> UPDATE;
                case "persistent" -> PERSISTENT;
                default -> NEVER;
            };
        }
    }

    @QuarkCommand(name="we-selection", aliases={"render-we", "/render-sel", "/render-selection", "/render", "render-we-selection"})
    public static final class WESessionRenderCommand
    extends ModuleCommand<WESessionRenderer> {
        public void suggest(CommandSuggestion suggestion) {
            suggestion.suggest(0, new String[]{"off", "render", "update", "persistent"});
        }

        public void execute(CommandExecution context) {
            if (!context.hasArgumentAt(0)) {
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)context.getSender(), (String)"render", (Object[])new Object[0]);
                ((WESessionRenderer)this.getModule()).render(context.requireSenderAsPlayer());
                return;
            }
            String action = context.requireEnum(0, new String[]{"off", "render", "update", "persistent"});
            if (Objects.equals(action, "render")) {
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)context.getSender(), (String)"render", (Object[])new Object[0]);
                ((WESessionRenderer)this.getModule()).render(context.requireSenderAsPlayer());
                return;
            }
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)context.getSender(), (String)("mode-" + action), (Object[])new Object[0]);
            ((WESessionRenderer)this.getModule()).modes.put(context.requireSenderAsPlayer(), RenderMode.of(action));
            ((WESessionRenderer)this.getModule()).save(context.requireSenderAsPlayer());
        }
    }
}

