/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.management;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.atcraftmc.qlib.command.LegacyCommandManager;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.BanList;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.foundation.platform.Players;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;
import org.tbstcraft.quark.util.CachedInfo;

@QuarkModule(version="1.0.0")
@QuarkCommand(name="ban")
public final class AdvancedBan
extends CommandModule {
    public void onCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("minecraft.command.ban")) {
            this.sendPermissionMessage(sender);
            return;
        }
        Calendar calender = Calendar.getInstance();
        switch (args[2]) {
            case "forever": {
                calender.set(9999, 11, 31, 23, 59, 59);
                break;
            }
            case "until": {
                calender.set(1, Integer.parseInt(args[3]));
                calender.set(2, Integer.parseInt(args[4]) - 1);
                calender.set(5, Integer.parseInt(args[5]));
                calender.set(10, Integer.parseInt(args[6]) - 12);
                calender.set(12, Integer.parseInt(args[7]));
                calender.set(13, Integer.parseInt(args[8]));
                break;
            }
            case "time": {
                calender.add(1, Integer.parseInt(args[3]));
                calender.add(2, Integer.parseInt(args[4]));
                calender.add(5, Integer.parseInt(args[5]));
                calender.add(10, Integer.parseInt(args[6]));
                calender.add(12, Integer.parseInt(args[7]));
                calender.add(13, Integer.parseInt(args[8]));
            }
        }
        String player = args[0];
        String reason = args[1];
        Players.banPlayer((String)player, (BanList.Type)BanList.Type.NAME, (String)reason, (Date)calender.getTime(), (String)sender.getName());
        String date = SharedObjects.DATE_FORMAT.format(calender.getTime());
        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"msg-ban-complete", (Object[])new Object[]{player, date, reason});
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"broadcast")) {
            MessageAccessor.broadcast((LanguageEntry)this.getLanguage(), (boolean)false, (boolean)false, (String)"broadcast", (Object[])new Object[]{player, reason, sender.getName(), date});
        }
    }

    public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
        switch (buffer.length) {
            case 1: {
                tabList.addAll(CachedInfo.getAllPlayerNames());
                break;
            }
            case 2: {
                tabList.add("[reason]");
                break;
            }
            case 3: {
                tabList.add("until");
                tabList.add("time");
                tabList.add("forever");
                return;
            }
        }
        if (buffer.length <= 3) {
            return;
        }
        if (Objects.equals(buffer[2], "forever")) {
            return;
        }
        switch (buffer.length) {
            case 4: {
                tabList.add("[year]");
                break;
            }
            case 5: {
                tabList.add("[month]");
                break;
            }
            case 6: {
                tabList.add("[day]");
                break;
            }
            case 7: {
                tabList.add("[hour]");
                break;
            }
            case 8: {
                tabList.add("[minute]");
                break;
            }
            case 9: {
                tabList.add("[second]");
            }
        }
    }

    public Command getCoveredCommand() {
        return LegacyCommandManager.getCommandMap().getCommand("minecraft:ban");
    }
}

