/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.management;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.gb2022.commons.reflect.Inject;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.PluginsCommand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.tbstcraft.quark.foundation.TextSender;
import org.tbstcraft.quark.foundation.platform.PluginUtil;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkCommand(name="plugins", aliases={"pl"}, op=true)
@QuarkModule(version="1.1.0")
public final class AdvancedPluginCommand
extends CommandModule {
    private final PluginUtil.ModernPluginManager pluginManager = PluginUtil.INSTANCE;
    private final PluginManager bukkitPluginManager = Bukkit.getPluginManager();
    @Inject
    private LanguageEntry language;

    private Component genMessage(String msg, Object ... fmt) {
        return Component.text((String)ChatColor.translateAlternateColorCodes((char)'&', (String)msg.formatted(fmt)));
    }

    public void execute(CommandExecution context) {
        switch (context.requireEnum(0, new String[]{"load", "unload", "reload", "enable", "disable", "restart", "info", "list"})) {
            case "load": {
                this.loadPlugin(context.getSender(), context.requireArgumentAt(1));
                break;
            }
            case "unload": {
                this.unloadPlugin(context.getSender(), context.requireArgumentAt(1));
                break;
            }
            case "reload": {
                this.reloadPlugin(context.getSender(), context.requireArgumentAt(1));
                break;
            }
            case "enable": {
                this.enablePlugin(context.getSender(), context.requireArgumentAt(1));
                break;
            }
            case "disable": {
                this.disablePlugin(context.getSender(), context.requireArgumentAt(1));
                break;
            }
            case "restart": {
                this.restartPlugin(context.getSender(), context.requireArgumentAt(1));
                break;
            }
            case "info": {
                this.sendPluginInfo(context.getSender(), context.requireArgumentAt(1));
                break;
            }
            case "list": {
                this.listPlugins(context.getSender());
            }
        }
    }

    public void suggest(CommandSuggestion suggestion) {
        suggestion.suggest(0, new String[]{"load", "unload", "reload", "enable", "disable", "restart", "info", "list"});
        Consumer<CommandSuggestion> ctx = new Consumer<CommandSuggestion>(){

            @Override
            public void accept(CommandSuggestion c) {
                c.suggest(1, (Collection)Arrays.stream(AdvancedPluginCommand.this.bukkitPluginManager.getPlugins()).map(Plugin::getName).collect(Collectors.toSet()));
            }
        };
        suggestion.matchArgument(0, "unload", (Consumer)ctx);
        suggestion.matchArgument(0, "reload", (Consumer)ctx);
        suggestion.matchArgument(0, "enable", (Consumer)ctx);
        suggestion.matchArgument(0, "disable", (Consumer)ctx);
        suggestion.matchArgument(0, "restart", (Consumer)ctx);
        suggestion.matchArgument(0, "info", (Consumer)ctx);
        suggestion.matchArgument(0, "load", c -> {
            for (File f : Objects.requireNonNull(new File(System.getProperty("user.dir") + "/plugins").listFiles())) {
                if (!f.getName().endsWith(".jar")) continue;
                c.suggest(1, new String[]{f.getName()});
            }
        });
    }

    public Command getCoveredCommand() {
        return new PluginsCommand("plugins");
    }

    private void enablePlugin(CommandSender sender, String name) {
        Plugin p = this.bukkitPluginManager.getPlugin(name);
        if (p == null) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"plugin-not-found", (Object[])new Object[]{name});
            return;
        }
        this.bukkitPluginManager.enablePlugin(p);
        MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"enable", (Object[])new Object[]{name});
    }

    private void disablePlugin(CommandSender sender, String name) {
        Plugin p = this.bukkitPluginManager.getPlugin(name);
        if (p == null) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"plugin-not-found", (Object[])new Object[]{name});
            return;
        }
        this.bukkitPluginManager.disablePlugin(p);
        MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"disable", (Object[])new Object[]{name});
    }

    private void restartPlugin(CommandSender sender, String name) {
        Plugin p = this.bukkitPluginManager.getPlugin(name);
        if (p == null) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"plugin-not-found", (Object[])new Object[]{name});
            return;
        }
        this.bukkitPluginManager.disablePlugin(p);
        this.bukkitPluginManager.enablePlugin(p);
        MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"restart", (Object[])new Object[]{name});
    }

    private void loadPlugin(CommandSender sender, String fileName) {
        File file = new File(System.getProperty("user.dir") + "/plugins/" + fileName);
        if (!file.exists()) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"file-not-found", (Object[])new Object[]{fileName});
            return;
        }
        if (this.pluginManager.load(fileName) != null) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"load", (Object[])new Object[]{fileName});
        } else {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"load-failed", (Object[])new Object[]{fileName});
        }
    }

    private boolean unloadPlugin(CommandSender sender, String name) {
        Plugin p = this.bukkitPluginManager.getPlugin(name);
        if (p == null) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"plugin-not-found", (Object[])new Object[]{name});
            return false;
        }
        if (this.pluginManager.unload(p)) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"unload", (Object[])new Object[]{name});
            return true;
        }
        MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"unload-failed", (Object[])new Object[]{name});
        return false;
    }

    private void reloadPlugin(CommandSender sender, String name) {
        Plugin p = this.bukkitPluginManager.getPlugin(name);
        if (p == null) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"plugin-not-found", (Object[])new Object[]{name});
            return;
        }
        if (!this.unloadPlugin(sender, name)) {
            return;
        }
        this.loadPlugin(sender, name);
    }

    private Component buildPluginHoverInfo(Plugin plugin) {
        String template = "&7Name: &b%s\n&7ID: &b%s\n&7Version: &d%s\n&7Authors: &f%s\n&7Website: &f%s\n&7Description: &f%s\n&f\n&7[click to view detail]\n";
        PluginDescriptionFile desc = plugin.getDescription();
        return this.genMessage(template, desc.getPrefix() == null ? desc.getName() : desc.getPrefix(), desc.getName(), desc.getVersion(), String.join((CharSequence)",", desc.getAuthors()), desc.getWebsite(), desc.getDescription());
    }

    private void listPlugins(CommandSender sender) {
        String template = "[%s&f]%s";
        MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"list", (Object[])new Object[]{""});
        for (Plugin p : Bukkit.getPluginManager().getPlugins()) {
            String status = this.bukkitPluginManager.isPluginEnabled(p) ? "&aE" : "&cD";
            String name = p.getName();
            Component msg = this.genMessage(template, status, name);
            msg = msg.hoverEvent((HoverEventSource)HoverEvent.showText((Component)this.buildPluginHoverInfo(p)));
            msg = msg.clickEvent(ClickEvent.runCommand((String)("/plugins info " + p.getDescription().getName())));
            TextSender.sendMessage((CommandSender)sender, (ComponentLike)msg);
        }
    }

    private void sendPluginInfo(CommandSender sender, String name) {
        Plugin pl = Bukkit.getPluginManager().getPlugin(name);
        if (pl == null) {
            this.sendExceptionMessage(sender);
            return;
        }
        PluginDescriptionFile desc = pl.getDescription();
        StringBuilder builder2 = new StringBuilder(512);
        LanguageEntry language = this.language;
        MinecraftLocale locale = LocaleService.locale((CommandSender)sender);
        builder2.append("  ").append(MessageAccessor.getMessage((LanguageEntry)language, (MinecraftLocale)locale, (String)"info-name", (Object[])new Object[]{desc.getName(), desc.getPrefix() == null ? desc.getName() : desc.getPrefix()})).append("\n");
        builder2.append("  ").append(MessageAccessor.getMessage((LanguageEntry)language, (MinecraftLocale)locale, (String)"info-version", (Object[])new Object[]{desc.getVersion()})).append("\n");
        builder2.append("  ").append(MessageAccessor.getMessage((LanguageEntry)language, (MinecraftLocale)locale, (String)"info-author", (Object[])new Object[]{Arrays.toString(desc.getAuthors().toArray())})).append("\n");
        builder2.append("  ").append(MessageAccessor.getMessage((LanguageEntry)language, (MinecraftLocale)locale, (String)"info-depend", (Object[])new Object[]{Arrays.toString(desc.getDepend().toArray())})).append("\n");
        builder2.append("  ").append(MessageAccessor.getMessage((LanguageEntry)language, (MinecraftLocale)locale, (String)"info-soft-depend", (Object[])new Object[]{Arrays.toString(desc.getSoftDepend().toArray())})).append("\n");
        builder2.append("  ").append(MessageAccessor.getMessage((LanguageEntry)language, (MinecraftLocale)locale, (String)"info-api", (Object[])new Object[]{desc.getAPIVersion()})).append("\n");
        builder2.append("  ").append(MessageAccessor.getMessage((LanguageEntry)language, (MinecraftLocale)locale, (String)"info-main", (Object[])new Object[]{desc.getMain()})).append("\n");
        builder2.append("  ").append(MessageAccessor.getMessage((LanguageEntry)language, (MinecraftLocale)locale, (String)"info-desc", (Object[])new Object[]{desc.getDescription() == null ? "[empty]" : desc.getDescription()})).append("\n");
        MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"info", (Object[])new Object[]{name, builder2.toString()});
    }
}

