/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.management;

import java.util.function.Function;
import me.gb2022.commons.reflect.AutoRegister;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.migration.ConfigAccessor;

@AutoRegister(value={"qb:el"})
@QuarkModule(version="1.0.0")
public final class KickOnReload
extends PackageModule {
    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getPlayer().isOp()) {
            return;
        }
        this.handle(event.getMessage().split(" ")[0].replaceFirst("/", ""));
    }

    @EventHandler
    public void onServerCommand(ServerCommandEvent event) {
        this.handle(event.getCommand().split(" ")[0]);
    }

    public void handle(String command) {
        if (command.equalsIgnoreCase("reload")) {
            this.kick(locale -> this.getLanguage().item("reload-hint").message(locale, new Object[0]));
        }
        if (command.equalsIgnoreCase("stop")) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.kickPlayer(this.getLanguage().item("stop-hint").message(LocaleService.locale((CommandSender)p), new Object[0]));
            }
        }
    }

    public void kick(Function<MinecraftLocale, String> builder2) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"op-ignore") && p.isOp()) continue;
            p.kickPlayer(builder2.apply(LocaleService.locale((CommandSender)p)));
        }
    }
}

