/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.management;

import java.util.List;
import me.gb2022.apm.local.PluginMessenger;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.permissions.Permission;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.0.0")
@AutoRegister(value={"qb:el"})
@CommandProvider(value={MaintenanceCommand.class})
public final class Maintenance
extends PackageModule {
    boolean isEnabled = false;
    @Inject(value="-quark.maintenance.bypass")
    private Permission bypass;

    @EventHandler
    public void onPreLogin(AsyncPlayerPreLoginEvent event) {
        if (!this.isEnabled) {
            return;
        }
        Player p = Bukkit.getOfflinePlayer((String)event.getName()).getPlayer();
        String locale = "zh-cn";
        if (p != null) {
            locale = LocaleService.saveGetMCPlayerLocale((Player)p);
            if (p.hasPermission(this.bypass)) {
                return;
            }
        }
        String message = MessageAccessor.getMessage((LanguageEntry)this.getLanguage(), (MinecraftLocale)LocaleService.locale((CommandSender)p), (String)"kick-message", (Object[])new Object[0]);
        String name = event.getPlayerProfile().getName();
        event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, PluginMessenger.queryKickMessage((String)name, (String)message, (String)locale));
    }

    public void kickAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.hasPermission(this.bypass)) continue;
            String msg = MessageAccessor.getMessage((LanguageEntry)this.getLanguage(), (MinecraftLocale)LocaleService.locale((CommandSender)player), (String)"kick-message", (Object[])new Object[0]);
            player.kickPlayer(msg);
        }
    }

    @QuarkCommand(name="maintenance", permission="-quark.maintenance.command")
    public static final class MaintenanceCommand
    extends ModuleCommand<Maintenance> {
        public void onCommand(CommandSender sender, String[] args) {
            this.checkException(args.length == 1);
            switch (args[0]) {
                case "enable": {
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"start", (Object[])new Object[0]);
                    ((Maintenance)this.getModule()).isEnabled = true;
                    ((Maintenance)this.getModule()).kickAll();
                    break;
                }
                case "disable": {
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"end", (Object[])new Object[0]);
                    ((Maintenance)this.getModule()).isEnabled = false;
                    break;
                }
                default: {
                    this.sendExceptionMessage(sender, new Throwable[0]);
                }
            }
        }

        public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
            tabList.add("enable");
            tabList.add("disable");
        }
    }
}

