/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.management;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.tbstcraft.quark.foundation.TextSender;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;

@QuarkCommand(name="system", permission="-quark.management.system")
@QuarkModule
public final class ServerInfo
extends CommandModule {
    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requireMethod(() -> World.class.getMethod("getChunkCount", new Class[0]));
    }

    public void execute(CommandExecution context) {
        this.msg(context, "{#purple}Server info:");
        this.msg(context, "{#gray}- {#dark_aqua}Players: {#aqua} %s\n{#gray}- {#dark_aqua}TPS: {#tps} {#dark_green}MSPT: {#green}{#mspt}\n{#gray}- {#dark_aqua}Memory: {#aqua} %sMB / %sMB\n".formatted(Bukkit.getOnlinePlayers().size(), Runtime.getRuntime().totalMemory() / 1049576L, Runtime.getRuntime().maxMemory() / 1049576L));
        this.msg(context, "{#gray}- {#dark-aqua}Worlds:");
        for (int i = 0; i < Bukkit.getWorlds().size(); ++i) {
            World world = (World)Bukkit.getWorlds().get(i);
            this.msg(context, this.world(world, i));
        }
    }

    public void suggest(CommandSuggestion suggestion) {
    }

    private void msg(CommandExecution ctx, String msg) {
        TextSender.sendMessage((CommandSender)ctx.getSender(), (ComponentLike)TextBuilder.buildComponent((String)msg, (Component[])new Component[0]));
    }

    private String world(World world, int id) {
        int entities = world.getEntityCount();
        int te = world.getTileEntityCount();
        int te_t = world.getTickableTileEntityCount();
        int players = world.getPlayerCount();
        String c = "{#dark_aqua}Chunks: {#aqua}%s".formatted(world.getChunkCount());
        String e = "{#dark_green}Entities: {#green}%s{#gray}(Players:{#green}%s{#gray})".formatted(entities, players);
        String be = "{#dark_purple}TileEntities: {#purple}%s{#gray}(Tick: {#purple}%s{#gray})".formatted(te, te_t);
        Object[] objectArray = new Object[4];
        objectArray[0] = world.getName();
        objectArray[1] = world.getUID();
        objectArray[2] = switch (world.getEnvironment()) {
            case World.Environment.NORMAL -> "{#green}";
            case World.Environment.NETHER -> "{#red}";
            case World.Environment.THE_END -> "{#purple}";
            default -> "{#aqua}";
        };
        objectArray[3] = id;
        String wid = "{hover(text,%s{#gray}(%s))}[%s%s{#white}]".formatted(objectArray);
        return "  %s %s %s %s{;}".formatted(wid, c, e, be);
    }
}

