/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.management;

import me.gb2022.commons.math.MathHelper;
import org.atcraftmc.qlib.PluginPlatform;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.tbstcraft.quark.foundation.platform.BukkitUtil;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.MessageAccessor;
import org.tbstcraft.quark.util.TemplateExpansion;

@QuarkModule
@QuarkCommand(name="tpsbar", permission="-quark.tpsbar")
public final class TPSBar
extends CommandModule {
    public static final TemplateExpansion TEMPLATE_EXPANSION = TemplateExpansion.build(b -> b.replacement("tps").replacement("mspt"));
    private final BossBar bar = Bukkit.createBossBar((String)"_tpsbar", (BarColor)BarColor.PURPLE, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);

    public void enable() {
        super.enable();
        TaskService.async().timer("tpsbar:update", 5L, 5L, () -> {
            String tps = BukkitUtil.formatTPS((double)BukkitUtil.getTPS());
            double msptValue = BukkitUtil.getMSPT();
            String mspt = BukkitUtil.formatMSPT((double)msptValue);
            String line = TEMPLATE_EXPANSION.expand(this.getConfig().value("line").string(), new Object[]{tps, mspt});
            if (!this.bar.getPlayers().isEmpty()) {
                this.bar.setTitle(PluginPlatform.instance().globalFormatMessage(line));
                if (msptValue < 15.0) {
                    this.bar.setColor(BarColor.GREEN);
                } else if (msptValue < 35.0) {
                    this.bar.setColor(BarColor.YELLOW);
                } else {
                    this.bar.setColor(BarColor.RED);
                }
                this.bar.setProgress(MathHelper.clamp((double)(msptValue / 50.0), (double)0.0, (double)1.0));
            }
        });
    }

    public void disable() {
        super.disable();
        TaskService.async().cancel("tpsbar:update");
        this.bar.removeAll();
    }

    public void execute(CommandExecution context) {
        Player player = context.requireSenderAsPlayer();
        if (this.bar.getPlayers().contains(player)) {
            this.bar.removePlayer(player);
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)player, (String)"false", (Object[])new Object[0]);
            return;
        }
        this.bar.addPlayer(player);
        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)player, (String)"true", (Object[])new Object[0]);
    }
}

