/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.security;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.gb2022.apm.local.PluginMessenger;
import me.gb2022.commons.nbt.NBTTagCompound;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.generator.WorldInfo;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.data.ModuleDataService;
import org.tbstcraft.quark.data.record.RecordEntry;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.foundation.region.SimpleRegion;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.framework.module.component.Components;
import org.tbstcraft.quark.framework.module.component.ModuleComponent;
import org.tbstcraft.quark.internal.placeholder.PlaceHolderService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@AutoRegister(value={"qb:el"})
@CommandProvider(value={ExplosionWhitelistCommand.class})
@QuarkModule(version="1.3.3")
@Components(value={BlockExplosionListener.class})
public final class ExplosionDefender
extends PackageModule {
    private final HashMap<String, SimpleRegion> whiteListedRegions = new HashMap();
    @Inject(value="explosion-defender;Time,World,X,Y,Z,Type")
    private RecordEntry record;

    public void enable() {
        this.loadRegions();
        this.record.open();
    }

    public void disable() {
        this.saveRegions();
        this.whiteListedRegions.clear();
        this.record.close();
    }

    public void loadRegions() {
        NBTTagCompound tag = ModuleDataService.getEntry((String)this.getId());
        this.whiteListedRegions.clear();
        for (String s : tag.getTagMap().keySet()) {
            this.whiteListedRegions.put(s, new SimpleRegion(tag.getCompoundTag(s)));
        }
    }

    public void saveRegions() {
        NBTTagCompound tag = ModuleDataService.getEntry((String)this.getId());
        for (String s : this.whiteListedRegions.keySet()) {
            tag.setCompoundTag(s, this.whiteListedRegions.get(s).serialize());
        }
        ModuleDataService.save((String)this.getId());
    }

    public HashMap<String, SimpleRegion> getWhiteListedRegions() {
        return this.whiteListedRegions;
    }

    public boolean matchRegion(Location loc) {
        for (SimpleRegion s : this.whiteListedRegions.values()) {
            if (!s.inBound(loc)) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        Entity e = event.getEntity();
        if (this.matchRegion(e.getLocation())) {
            return;
        }
        event.setCancelled(true);
        this.handle(e.getLocation(), e.getType().getKey().toString());
    }

    public void handle(Location loc, String explodedId) {
        PluginMessenger.broadcastMapped((String)"quark:explosion", b -> b.put((Object)"loc", (Object)loc));
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"override-explosion")) {
            Objects.requireNonNull(loc.getWorld()).createExplosion(loc, 4.0f, false, false);
        }
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"broadcast")) {
            MessageAccessor.broadcast((LanguageEntry)this.getLanguage(), (boolean)true, (boolean)false, (String)"exploded", (Object[])new Object[]{Objects.requireNonNull(loc.getWorld()).getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), explodedId});
        }
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"record")) {
            this.record.addLine(new Object[]{SharedObjects.DATE_FORMAT.format(new Date()), Objects.requireNonNull(loc.getWorld()).getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), explodedId});
        }
    }

    @AutoRegister(value={"qb:el"})
    public static final class BlockExplosionListener
    extends ModuleComponent<ExplosionDefender> {
        public void checkCompatibility() throws APIIncompatibleException {
            Compatibility.requireClass(() -> Class.forName("org.bukkit.event.block.BlockExplodeEvent"));
        }

        @EventHandler
        public void onBlockExplode(BlockExplodeEvent event) {
            Block b = event.getBlock();
            if (((ExplosionDefender)this.parent).matchRegion(b.getLocation())) {
                return;
            }
            event.setCancelled(true);
            ((ExplosionDefender)this.parent).handle(b.getLocation(), "[?]");
        }
    }

    @QuarkCommand(name="explosion-whitelist", permission="-quark.explosion.whitelist")
    public static final class ExplosionWhitelistCommand
    extends ModuleCommand<ExplosionDefender> {
        public void onCommand(CommandSender sender, String[] args) {
            String operation = args[0];
            if (Objects.equals(operation, "list")) {
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"region-list", (Object[])new Object[0]);
                HashMap<String, SimpleRegion> map = ((ExplosionDefender)this.getModule()).getWhiteListedRegions();
                for (String s : map.keySet()) {
                    sender.sendMessage(PlaceHolderService.format((String)"{#gold}%s {#gray}-> {#white}%s".formatted(s, ((SimpleRegion)map.get(s)).toString())));
                }
                return;
            }
            String arg2 = args[1];
            if (Objects.equals(operation, "add")) {
                this.checkException(args.length == 9);
                if (((ExplosionDefender)this.getModule()).getWhiteListedRegions().containsKey(arg2)) {
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"region-add-failed", (Object[])new Object[]{arg2});
                    return;
                }
                ((ExplosionDefender)this.getModule()).getWhiteListedRegions().put(arg2, new SimpleRegion(Bukkit.getWorld((String)args[2]), Integer.parseInt(args[3]), Integer.parseInt(args[4]), Integer.parseInt(args[5]), Integer.parseInt(args[6]), Integer.parseInt(args[7]), Integer.parseInt(args[8])));
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"region-add", (Object[])new Object[]{arg2});
                ((ExplosionDefender)this.getModule()).saveRegions();
                return;
            }
            if (Objects.equals(operation, "remove")) {
                this.checkException(args.length == 2);
                if (!((ExplosionDefender)this.getModule()).getWhiteListedRegions().containsKey(arg2)) {
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"region-remove-failed", (Object[])new Object[]{arg2});
                    throw new RuntimeException("???");
                }
                ((ExplosionDefender)this.getModule()).getWhiteListedRegions().remove(arg2);
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"region-remove", (Object[])new Object[]{arg2});
            }
        }

        public void suggest(CommandSuggestion suggestion) {
            suggestion.suggest(0, new String[]{"add", "remove", "list"});
            suggestion.matchArgument(0, "add", s -> s.suggest(1, new String[]{"[name]"}));
            suggestion.matchArgument(0, "remove", s -> {
                Set<String> c = ((ExplosionDefender)this.getModule()).getWhiteListedRegions().keySet();
                s.suggest(1, c);
            });
            CommandSender sender = suggestion.getSender();
            boolean isPlayer = sender instanceof Player;
            suggestion.matchArgument(0, "add", s -> {
                s.suggest(2, (Collection)Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toSet()));
                s.suggest(3, new String[]{isPlayer ? String.valueOf(suggestion.getSenderAsPlayer().getLocation().getBlockX()) : "0"});
                s.suggest(4, new String[]{isPlayer ? String.valueOf(suggestion.getSenderAsPlayer().getLocation().getBlockY()) : "0"});
                s.suggest(5, new String[]{isPlayer ? String.valueOf(suggestion.getSenderAsPlayer().getLocation().getBlockZ()) : "0"});
                s.suggest(6, new String[]{isPlayer ? String.valueOf(suggestion.getSenderAsPlayer().getLocation().getBlockX()) : "3"});
                s.suggest(7, new String[]{isPlayer ? String.valueOf(suggestion.getSenderAsPlayer().getLocation().getBlockY()) : "3"});
                s.suggest(8, new String[]{isPlayer ? String.valueOf(suggestion.getSenderAsPlayer().getLocation().getBlockZ()) : "3"});
            });
        }
    }
}

