/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.security;

import com.google.gson.JsonObject;
import java.net.InetSocketAddress;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import me.gb2022.apm.local.PluginMessenger;
import me.gb2022.commons.TriState;
import me.gb2022.commons.http.HttpMethod;
import me.gb2022.commons.http.HttpRequest;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecutor;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.bukkit.BanList;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.data.PlayerDataService;
import org.tbstcraft.quark.data.record.RecordEntry;
import org.tbstcraft.quark.data.storage.DataEntry;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.command.QuarkCommandExecutor;
import org.tbstcraft.quark.foundation.platform.Players;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@AutoRegister(value={"qb:el"})
@QuarkModule(version="1.3.4")
@CommandProvider(value={IPQueryCommand.class})
public final class IPDefender
extends PackageModule
implements QuarkCommandExecutor {
    @Inject
    private LanguageEntry language;
    @Inject(value="ip-defender;Time,Player,OldIP,NewIP")
    private RecordEntry record;
    private IPService service;

    public static String defaultResult(MinecraftLocale locale) {
        if (List.of(MinecraftLocale.ZH_CN, MinecraftLocale.ZH_HK, MinecraftLocale.ZH_TW, MinecraftLocale.LZH).contains(locale)) {
            return "[\u672a\u77e5]";
        }
        return "unknown";
    }

    public void enable() {
        this.service = switch (this.getConfig().value("service").string()) {
            case "ip-api" -> new IPService.IP_API();
            case "ua-info" -> new IPService.UserAgentInfo();
            case "baidu" -> new IPService.Baidu();
            default -> {
                this.getL4jLogger().error("unknown service: {},using default ip-api service", (Object)this.getConfig().value("service").string());
                yield new IPService.IP_API();
            }
        };
    }

    public void onCommand(CommandSender sender, String[] args) {
        TaskService.async().run(() -> MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"check", (Object[])new Object[]{this.query((Player)sender)}));
    }

    public void check(Player player) {
        String previous;
        TriState state;
        String current = this.query(player.getAddress(), MinecraftLocale.EN_US);
        DataEntry data = PlayerDataService.get((Player)player);
        if (!data.hasKey("ip-address")) {
            data.setString("ip-address", current);
            data.save();
            state = TriState.UNKNOWN;
            previous = null;
        } else {
            previous = data.getString("ip-address");
            if (Objects.equals(previous, current)) {
                state = TriState.FALSE;
            } else {
                data.setString("ip-address", current);
                data.save();
                state = TriState.TRUE;
            }
        }
        if (state == TriState.FALSE) {
            return;
        }
        String currentDisplay = this.query(player);
        if (state == TriState.UNKNOWN) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)player, (String)"detect", (Object[])new Object[]{currentDisplay});
            return;
        }
        MessageAccessor.send((LanguageEntry)this.language, (CommandSender)player, (String)"warn", (Object[])new Object[]{currentDisplay});
        PluginMessenger.broadcastMapped((String)"ip:change", map -> {
            map.put((Object)"player", (Object)player.getName());
            map.put((Object)"old-ip", (Object)previous);
            map.put((Object)"new-ip", (Object)current);
        });
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"record")) {
            this.record.addLine(new Object[]{SharedObjects.DATE_FORMAT.format(new Date()), player.getName(), previous, current});
        }
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"auto_ban")) {
            String name = player.getName();
            String reason = this.getLanguage().item("auto_ban_reason").message(LocaleService.locale((CommandSender)player), new Object[0]);
            int day = ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"auto_ban_day_time");
            int hour = ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"auto_ban_hour_time");
            int minute = ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"auto_ban_minute_time");
            int second = ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"auto_ban_second_time");
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, day);
            calendar.add(10, hour);
            calendar.add(12, minute);
            calendar.add(13, second);
            Players.banPlayer((String)name, (BanList.Type)BanList.Type.NAME, (String)reason, (Date)calendar.getTime(), (String)"quark");
        }
    }

    public String query(InetSocketAddress address, MinecraftLocale locale) {
        if (address == null) {
            return IPDefender.defaultResult(locale);
        }
        String result = this.service.parse(address, locale);
        if (IPService.isError(result)) {
            return IPDefender.defaultResult(locale);
        }
        return result;
    }

    public String query(Player player) {
        return this.query(player.getAddress(), LocaleService.locale((CommandSender)player));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        TaskService.async().run(() -> this.check(event.getPlayer()));
    }

    static interface IPService {
        public static final Logger LOGGER = LogManager.getLogger((String)"Quark-Plugin/IPService");
        public static final String RES_UNKNOWN = "[error]Unknown or LAN address";
        public static final String RES_NET_ERROR = "[error]Network error";
        public static final String RES_UNEXPECTED_RESPONSE = "[error]Unexpected response from server";

        public static boolean isError(String resp) {
            return resp.startsWith("[error]");
        }

        public HttpRequest buildRequest(InetSocketAddress var1, MinecraftLocale var2);

        public String parse(JsonObject var1);

        default public String parse(InetSocketAddress address, MinecraftLocale locale) {
            String resp = null;
            JsonObject dom = null;
            try {
                resp = this.buildRequest(address, locale).request();
            }
            catch (Exception e) {
                LOGGER.error(RES_NET_ERROR);
                LOGGER.catching((Throwable)e);
                return RES_NET_ERROR;
            }
            try {
                dom = SharedObjects.JSON_PARSER.parse(resp).getAsJsonObject();
            }
            catch (Exception e) {
                LOGGER.error(RES_UNEXPECTED_RESPONSE);
                LOGGER.error(resp);
                LOGGER.catching((Throwable)e);
                return RES_UNEXPECTED_RESPONSE;
            }
            return this.parse(dom);
        }

        public static class UserAgentInfo
        implements IPService {
            @Override
            public HttpRequest buildRequest(InetSocketAddress address, MinecraftLocale locale) {
                return HttpRequest.http((HttpMethod)HttpMethod.GET, (String)"ip.useragentinfo.com/json").param("ip", address.getHostName()).browserBehavior(true).build();
            }

            @Override
            public String parse(JsonObject response) {
                String country = response.get("country").getAsString();
                String province = response.get("province").getAsString();
                String city = response.get("city").getAsString();
                if (response.has("desc") && Objects.equals(response.get("desc").getAsString(), "query fail")) {
                    return IPService.RES_UNKNOWN;
                }
                return "%s-%s-%s".formatted(country, province, city);
            }
        }

        public static class Baidu
        implements IPService {
            @Override
            public String parse(JsonObject response) {
                if (response.getAsJsonArray("data").isEmpty()) {
                    return IPService.RES_UNKNOWN;
                }
                return response.getAsJsonArray("data").get(0).getAsJsonObject().get("location").getAsString();
            }

            @Override
            public HttpRequest buildRequest(InetSocketAddress address, MinecraftLocale locale) {
                return HttpRequest.http((HttpMethod)HttpMethod.GET, (String)"opendata.baidu.com/api.php").param("query", address.getHostName()).param("co", "").param("resource_id", "6006").param("oe", "utf8").browserBehavior(true).build();
            }
        }

        public static class IP_API
        implements IPService {
            @Override
            public HttpRequest buildRequest(InetSocketAddress address, MinecraftLocale locale) {
                return HttpRequest.http((HttpMethod)HttpMethod.GET, (String)"ip-api.com/json").path(address.getHostName()).param("lang", locale.toString().replace("_", "-")).browserBehavior(false).build();
            }

            @Override
            public String parse(JsonObject response) {
                String country = response.get("country").getAsString();
                String regionName = response.get("regionName").getAsString();
                String city = response.get("city").getAsString();
                String result = "%s-%s-%s".formatted(country, regionName, city);
                if (Objects.equals(result, "null-null-null")) {
                    return IPService.RES_UNKNOWN;
                }
                return result;
            }
        }
    }

    @QuarkCommand(name="check-ip", permission="+quark.ip.query", playerOnly=true)
    public static final class IPQueryCommand
    extends ModuleCommand<IPDefender> {
        public void init(IPDefender module) {
            this.setExecutor((CommandExecutor)module);
        }
    }
}

