/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.security;

import java.util.Date;
import java.util.List;
import me.gb2022.apm.local.PluginMessenger;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.data.record.RecordEntry;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@AutoRegister(value={"qb:el"})
@QuarkModule(version="1.2.2", recordFormat={})
public final class ItemDefender
extends PackageModule {
    @Inject
    private LanguageEntry language;
    @Inject(value="item-defender;Time,Level,Player,World,X,Y,Z,Type,Action")
    private RecordEntry record;

    @EventHandler
    public void onItemHeld(PlayerItemHeldEvent event) {
        this.checkEvent(event.getPlayer(), event.getPlayer().getInventory().getItem(event.getNewSlot()), true, "Held");
    }

    @EventHandler
    public void onItemConsume(PlayerItemConsumeEvent event) {
        this.checkEvent(event.getPlayer(), event.getItem(), true, "Consume");
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        this.checkEvent(event.getPlayer(), event.getItem(), false, "Interact");
    }

    @EventHandler
    public void onItemSwap(PlayerSwapHandItemsEvent event) {
        this.checkEvent(event.getPlayer(), event.getMainHandItem(), true, "Swap");
        this.checkEvent(event.getPlayer(), event.getOffHandItem(), true, "Swap");
    }

    private void checkEvent(Player p, ItemStack stack, boolean say, String action) {
        if (stack == null) {
            return;
        }
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"op-ignore") && p.isOp()) {
            return;
        }
        Material m = stack.getType();
        boolean itemIllegal = this.isItemIllegal(m);
        boolean b2 = this.isItemWarning(m);
        if (!itemIllegal && !b2) {
            return;
        }
        if (itemIllegal) {
            p.getInventory().remove(m);
        }
        if (itemIllegal && b2) {
            b2 = false;
        }
        if (say) {
            if (itemIllegal) {
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)p, (String)"illegal-item", (Object[])new Object[]{m.getKey().toString()});
            } else {
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)p, (String)"warning-item", (Object[])new Object[]{m.getKey().toString()});
            }
        }
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"record")) {
            this.record.addLine(new Object[]{SharedObjects.DATE_FORMAT.format(new Date()), b2 ? "Warning" : "Illegal", p.getName(), p.getLocation().getWorld().getName(), p.getLocation().getBlockX(), p.getLocation().getBlockY(), p.getLocation().getBlockZ(), m.getKey().toString(), action});
        }
        PluginMessenger.broadcastMapped((String)"item:access", map -> map.put((Object)"player", (Object)p.getName()).put((Object)"type", (Object)(itemIllegal ? "illegal" : "warning")).put((Object)"item", (Object)m.getKey().getKey()));
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"broadcast")) {
            if (itemIllegal) {
                MessageAccessor.broadcast((LanguageEntry)this.language, (boolean)true, (boolean)false, (String)"illegal-item-broadcast", (Object[])new Object[]{p.getName(), m.getKey().toString()});
            } else {
                MessageAccessor.broadcast((LanguageEntry)this.language, (boolean)true, (boolean)false, (String)"warning-item-broadcast", (Object[])new Object[]{p.getName(), m.getKey().toString()});
            }
        }
    }

    private boolean isItemIllegal(Material material) {
        List list = ConfigAccessor.configList((ConfigEntry)this.getConfig(), (String)"illegal-list", String.class);
        return list.contains(material.getKey().getKey());
    }

    private boolean isItemWarning(Material material) {
        List list = ConfigAccessor.configList((ConfigEntry)this.getConfig(), (String)"warning-list", String.class);
        return list.contains(material.getKey().getKey());
    }
}

