/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.security;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.gb2022.commons.nbt.NBTBase;
import me.gb2022.commons.nbt.NBTTagCompound;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.apache.logging.log4j.Logger;
import org.atcraftmc.qlib.bukkit.util.permission.PermissionEventHandler;
import org.atcraftmc.qlib.bukkit.util.permission.PlayerPermissionManager;
import org.atcraftmc.qlib.bukkit.util.permission.VirtualPermissionAttachment;
import org.atcraftmc.qlib.command.LegacyCommandManager;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandExecutor;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.tbstcraft.quark.Quark;
import org.tbstcraft.quark.data.PlayerDataService;
import org.tbstcraft.quark.data.assets.AssetGroup;
import org.tbstcraft.quark.data.storage.DataEntry;
import org.tbstcraft.quark.data.storage.StorageTable;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.command.QuarkCommandExecutor;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.permission.PermissionEntry;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.MessageAccessor;

@AutoRegister(value={"qb:el"})
@CommandProvider(value={PermissionCommand.class})
@QuarkModule(version="1.0.3")
public final class PermissionManager
extends PackageModule
implements QuarkCommandExecutor,
PermissionEventHandler {
    private final PlayerPermissionManager service = new PlayerPermissionManager((Plugin)Quark.getInstance(), (PermissionEventHandler)this);
    private final Map<String, List<String>> tags = new HashMap<String, List<String>>();
    private final Map<String, ConfigurationSection> groups = new HashMap<String, ConfigurationSection>();
    @Inject
    private Logger logger;
    @Inject
    private LanguageEntry language;
    @Inject(value="permission;false")
    private AssetGroup permissionConfigs;

    private static void setPermission(PermissionAttachment attachment, List<String> permissions) {
        for (String item : permissions) {
            String name = item.substring(1);
            if (item.charAt(0) == '+') {
                attachment.setPermission(name, true);
            }
            if (item.charAt(0) != '-') continue;
            attachment.setPermission(name, false);
        }
    }

    public void onAttachmentCreated(UUID uuid, PermissionAttachment attachment) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            throw new IllegalArgumentException("Player not found: " + uuid);
        }
        this.sync(player, attachment);
    }

    public void sync(Player player, PermissionAttachment attachment) {
        String group;
        ConfigurationSection section;
        NBTTagCompound data = PlayerDataService.getEntry((String)player.getName(), (String)this.getId());
        ArrayList<String> permissions = new ArrayList<String>();
        ArrayList tags = new ArrayList();
        if (!data.hasKey("group")) {
            data.setString("group", player.isOp() ? "--operator" : "--player");
            this.logger.info("set default permission group {} to {}", (Object)data.getString("group"), (Object)player.getName());
            PlayerDataService.save((String)player.getName());
        }
        if ((section = this.groups.get(group = data.getString("group"))) != null) {
            permissions.addAll(section.getStringList("permissions"));
            tags.addAll(section.getStringList("tags"));
        } else {
            this.logger.warn("detected unknown permission group of player {}: {}", (Object)player.getName(), (Object)group);
        }
        tags.addAll(this.getPermissionTags(player.getName()).getTagMap().keySet());
        HashSet keys = new HashSet(data.getTagMap().keySet());
        keys.remove("group");
        keys.remove("tags");
        for (String key : keys) {
            try {
                permissions.add((String)(data.getBoolean(key) ? "+" : "-" + key));
            }
            catch (ClassCastException ignored) {
                this.logger.warn("attempt to fetch invalid permission data {} for %{}", (Object)key, (Object)player.getName());
            }
        }
        for (String tag : tags) {
            List<String> tagPermissions = this.tags.get(tag);
            if (tagPermissions == null) {
                this.logger.warn("find an unknown permission tag of player {} : {}", (Object)player.getName(), (Object)tag);
                continue;
            }
            PermissionManager.setPermission(attachment, tagPermissions);
        }
        PermissionManager.setPermission(attachment, permissions);
        TaskService.async().delay(10L, LegacyCommandManager::sync);
    }

    public void enable() {
        if (!this.permissionConfigs.existFolder()) {
            this.permissionConfigs.save("worldedit.yml");
            this.permissionConfigs.save("minecraft.yml");
            this.permissionConfigs.save("default-groups.yml");
        }
        for (String cfg : this.permissionConfigs.list()) {
            YamlConfiguration dom = YamlConfiguration.loadConfiguration((File)this.permissionConfigs.getFile(cfg));
            if (dom.contains("tags")) {
                ConfigurationSection tags = dom.getConfigurationSection("tags");
                assert (tags != null);
                for (String tagName : tags.getKeys(false)) {
                    this.tags.put(tagName, dom.getStringList(tagName));
                    for (String item : tags.getStringList(tagName)) {
                        this.tags.get(tagName).add(item);
                    }
                }
                this.logger.info("loaded configuration file {} as tag provider.", (Object)cfg);
                continue;
            }
            if (dom.contains("groups")) {
                ConfigurationSection group = dom.getConfigurationSection("groups");
                assert (group != null);
                for (String groupName : group.getKeys(false)) {
                    this.groups.put(groupName, group.getConfigurationSection(groupName));
                }
                this.logger.info("loaded configuration file {} as group provider.", (Object)cfg);
                continue;
            }
            this.logger.info("skipped unknown config file {}", (Object)cfg);
        }
        this.service.initialize();
    }

    public void disable() {
        this.service.release();
    }

    private StorageTable getPermissionTags(String name) {
        DataEntry data = PlayerDataService.get((String)name);
        if (!data.hasKey("tags")) {
            data.setTag("tags", (NBTBase)new NBTTagCompound());
        }
        return data.getTable("tags");
    }

    public void execute(CommandExecution context) {
        OfflinePlayer target = context.requireOfflinePlayer(1);
        String playerName = context.requireArgumentAt(1);
        String name = context.requireArgumentAt(2);
        CommandSender sender = context.getSender();
        DataEntry data = PlayerDataService.get((OfflinePlayer)target);
        StorageTable table = data.getTable(this.getId());
        switch (context.requireEnum(0, new String[]{"set", "add-tag", "remove-tag", "group"})) {
            case "set": {
                String value = context.requireArgumentAt(3);
                if (Objects.equals(value, "unset")) {
                    table.remove(name);
                } else {
                    table.setBoolean(name, Boolean.parseBoolean(value));
                }
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"cmd-perm-set", (Object[])new Object[]{playerName, "{;}" + name, value});
                break;
            }
            case "add-tag": {
                this.getPermissionTags(playerName).setString(name, name);
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"cmd-tag-add", (Object[])new Object[]{playerName, name});
                break;
            }
            case "remove-tag": {
                this.getPermissionTags(playerName).remove(name);
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"cmd-tag-remove", (Object[])new Object[]{playerName, name});
                break;
            }
            case "group": {
                data.setString("group", name);
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"cmd-group-set", (Object[])new Object[]{playerName, name});
            }
        }
        data.save();
        if (!target.isOnline()) {
            return;
        }
        VirtualPermissionAttachment attachment = this.service.attachment(target.getPlayer());
        this.sync(Objects.requireNonNull(target.getPlayer()), (PermissionAttachment)attachment);
        attachment.refresh();
    }

    public void suggest(CommandSuggestion suggestion) {
        suggestion.suggest(0, new String[]{"set", "add-tag", "remove-tag", "group"});
        suggestion.matchArgument(0, "set", c -> c.suggest(2, (Collection)PermissionEntry.getAllPermissions()));
        suggestion.matchArgument(0, "add-tag", c -> c.suggest(2, this.tags.keySet()));
        suggestion.matchArgument(0, "group", c -> c.suggest(2, this.groups.keySet()));
        suggestion.matchArgument(0, "remove-tag", c -> c.suggest(2, new String[]{"<tag-name>"}));
        suggestion.suggestPlayers(1);
        suggestion.matchArgument(0, "set", c -> c.suggest(3, new String[]{"true", "false", "unset"}));
    }

    @QuarkCommand(name="permission", permission="-quark.permission.command")
    public static final class PermissionCommand
    extends ModuleCommand<PermissionManager> {
        public void init(PermissionManager module) {
            this.setExecutor((CommandExecutor)module);
        }
    }
}

