/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.gb2022.commons.nbt.NBTTagCompound;
import me.gb2022.commons.reflect.AutoRegister;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.tbstcraft.quark.data.ModuleDataService;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.platform.Players;
import org.tbstcraft.quark.foundation.region.Region;
import org.tbstcraft.quark.foundation.region.RegionDataManager;
import org.tbstcraft.quark.foundation.region.RegionManager;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@Deprecated(since="//\u6ca1\u505a\u5b8c\uff0c\u4f46\u662f\u4ed6\u4eec\u8bf4\u4e0d\u9700\u8981\u4e86")
@QuarkModule
@AutoRegister(value={"qb:el"})
public class PlotManager
extends PackageModule {
    private final Map<String, PlotRegion> editModePlayers = new HashMap<String, PlotRegion>();
    private RegionManager<PlotRegion> regionManager;

    public void enable() {
        this.regionManager = new RegionManager(PlotRegion.class, RegionDataManager.NBT((NBTTagCompound)ModuleDataService.getEntry((String)this.getFullId())));
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.editModePlayers.remove(event.getPlayer().getName());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        PlotRegion region = (PlotRegion)this.regionManager.getMinIntersected(event.getPlayer().getLocation());
        if (this.editModePlayers.containsKey(player.getName())) {
            event.setCancelled(true);
            if (region != null) {
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)event.getPlayer(), (String)"edit-conflict", (Object[])new Object[0]);
                return;
            }
            PlotRegion edit = this.editModePlayers.get(player.getName());
            if (event.hasBlock()) {
                return;
            }
            if (event.getAction().isLeftClick()) {
                edit.setPoint0(Objects.requireNonNull(event.getClickedBlock()).getLocation());
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)event.getPlayer(), (String)"edit-p0", (Object[])new Object[0]);
            }
            if (event.getAction().isRightClick()) {
                edit.setPoint1(Objects.requireNonNull(event.getClickedBlock()).getLocation());
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)event.getPlayer(), (String)"edit-p1", (Object[])new Object[0]);
            }
            Players.show3DBox((Player)event.getPlayer(), (Location)edit.getPoint0(), (Location)edit.getPoint1());
            return;
        }
        if (region == null) {
            if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"allow-access-public-area")) {
                return;
            }
            event.setCancelled(true);
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)event.getPlayer(), (String)"deny-public-area", (Object[])new Object[0]);
            return;
        }
        if (region.canAccess(event.getPlayer().getName())) {
            return;
        }
        event.setCancelled(true);
        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)event.getPlayer(), (String)"deny-inside-area", (Object[])new Object[]{region.getOwner()});
    }

    private void startEditing(Player player) {
        PlotRegion region = new PlotRegion(player.getName(), player.getWorld());
        this.editModePlayers.put(player.getName(), region);
    }

    private EditResult stopEditing(Player player) {
        PlotRegion region = this.editModePlayers.get(player.getName());
        if (region == null) {
            return EditResult.NOT_FOUND;
        }
        if (!region.isComplete()) {
            return EditResult.NOT_COMPLETE;
        }
        if (region.asAABB().getMaxWidth() > (double)ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"own-count")) {
            return EditResult.TOO_BIG;
        }
        if (this.regionManager.filter(r -> Objects.equals(r.getOwner(), player.getName())).size() > ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"own-count")) {
            return EditResult.CANNOT_ALLOCATE;
        }
        this.regionManager.addRegion(region.getOwner(), (Region)region);
        this.regionManager.saveRegions();
        ModuleDataService.save((String)this.getFullId());
        return EditResult.COMPLETE;
    }

    private static class PlotRegion
    extends Region {
        Set<String> members = new HashSet<String>();
        String owner;

        public PlotRegion(String owner, World world, int x0, int y0, int z0, int x1, int y1, int z1) {
            super(world, x0, y0, z0, x1, y1, z1);
            this.owner = owner;
        }

        public PlotRegion(String owner, World world) {
            super(world);
            this.owner = owner;
        }

        public void readAdditionData(NBTTagCompound addition) {
            this.owner = addition.getString("owner");
        }

        public void writeAdditionData(NBTTagCompound addition) {
            addition.setString("owner", this.owner);
        }

        public Set<String> getMembers() {
            return this.members;
        }

        public String getOwner() {
            return this.owner;
        }

        public boolean canAccess(String name) {
            return Objects.equals(this.owner, name) || this.members.contains(name);
        }
    }

    private static enum EditResult {
        NOT_FOUND,
        TOO_BIG,
        NOT_COMPLETE,
        COMPLETE,
        CANNOT_ALLOCATE;

    }

    public static final class PlotCommand
    extends ModuleCommand<PlotManager> {
    }
}

