/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.security;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import me.gb2022.commons.nbt.NBTTagCompound;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.quark.security.WESessionTrackService;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.data.ModuleDataService;
import org.tbstcraft.quark.data.record.RecordEntry;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.region.Region;
import org.tbstcraft.quark.foundation.region.SimpleRegion;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.placeholder.PlaceHolderService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@AutoRegister(value={"qb:el"})
@CommandProvider(value={ProtectionAreaCommand.class})
@QuarkModule(version="1.3.4", recordFormat={"Time", "Player", "World", "X", "Y", "Z", "Region"})
public final class ProtectionArea
extends PackageModule {
    private final HashMap<String, SimpleRegion> regions = new HashMap();
    @Inject(value="limited-area;Time,Player,World,X,Y,Z,Region")
    private RecordEntry record;

    public void enable() {
        this.loadRegions();
    }

    public void disable() {
        this.saveRegions();
        this.regions.clear();
    }

    public void loadRegions() {
        NBTTagCompound tag = ModuleDataService.getEntry((String)this.getId());
        this.regions.clear();
        for (String s : tag.getTagMap().keySet()) {
            this.regions.put(s, new SimpleRegion(tag.getCompoundTag(s)));
        }
    }

    public void saveRegions() {
        NBTTagCompound tag = ModuleDataService.getEntry((String)this.getId());
        for (String s : this.regions.keySet()) {
            tag.setCompoundTag(s, this.regions.get(s).serialize());
        }
        ModuleDataService.save((String)this.getId());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInteract(PlayerInteractEvent event) {
        ItemStack i = event.getPlayer().getInventory().getItem(event.getPlayer().getInventory().getHeldItemSlot());
        if (Bukkit.getPluginManager().isPluginEnabled("WorldEdit") && i != null && i.getType() == Material.WOODEN_AXE && event.getPlayer().hasPermission("worldedit.region.*")) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        this.check(event.getClickedBlock().getLocation(), event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        this.check(event.getBlock().getLocation(), event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldEditCommand(PlayerCommandPreprocessEvent event) {
        if (!Bukkit.getPluginManager().isPluginEnabled("WorldEdit")) {
            return;
        }
        if (event.getMessage().startsWith("//pos1")) {
            return;
        }
        if (event.getMessage().startsWith("//pos2")) {
            return;
        }
        if (event.getMessage().startsWith("//")) {
            Player player = event.getPlayer();
            if (Objects.requireNonNull(player.getPlayer()).isOp()) {
                return;
            }
            SimpleRegion r = WESessionTrackService.getRegion(player);
            for (Region region : this.regions.values()) {
                if (!region.asAABB().intersects(r.asAABB())) continue;
                event.setCancelled(true);
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)player, (String)"interact_blocked_we", (Object[])new Object[0]);
                if (!ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"record")) {
                    return;
                }
                Player p = event.getPlayer();
                Location loc = p.getLocation();
                this.record.addLine(new Object[]{SharedObjects.DATE_FORMAT.format(new Date()), p.getName(), p.getLocation().getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), region.toString()});
                return;
            }
        }
    }

    private void check(Location loc, Player player, Cancellable event) {
        if (Objects.requireNonNull(player.getPlayer()).isOp()) {
            return;
        }
        for (Region region : this.regions.values()) {
            if (!region.inBound(loc) || !Bukkit.getPluginManager().isPluginEnabled("WorldEdit")) continue;
            event.setCancelled(true);
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)player, (String)"interact_blocked", (Object[])new Object[0]);
            if (!ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"record")) {
                return;
            }
            this.record.addLine(new Object[]{SharedObjects.DATE_FORMAT.format(new Date()), player.getName(), player.getLocation().getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), region.toString()});
            return;
        }
    }

    public HashMap<String, SimpleRegion> getRegions() {
        return this.regions;
    }

    @QuarkCommand(name="protection-area", op=true)
    public static final class ProtectionAreaCommand
    extends ModuleCommand<ProtectionArea> {
        public void onCommand(CommandSender sender, String[] args) {
            String operation = args[0];
            if (Objects.equals(operation, "list")) {
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"region_list", (Object[])new Object[0]);
                HashMap<String, SimpleRegion> map = ((ProtectionArea)this.getModule()).getRegions();
                for (String s : map.keySet()) {
                    sender.sendMessage(PlaceHolderService.format((String)"{#gold}%s {#gray}-> {#white}%s".formatted(s, ((SimpleRegion)map.get(s)).toString())));
                }
                return;
            }
            String arg2 = args[1];
            if (Objects.equals(operation, "add")) {
                this.checkException(args.length == 9);
                if (((ProtectionArea)this.getModule()).getRegions().containsKey(arg2)) {
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"region_add_failed", (Object[])new Object[]{arg2});
                    return;
                }
                ((ProtectionArea)this.getModule()).getRegions().put(arg2, new SimpleRegion(Bukkit.getWorld((String)args[2]), Integer.parseInt(args[3]), Integer.parseInt(args[4]), Integer.parseInt(args[5]), Integer.parseInt(args[6]), Integer.parseInt(args[7]), Integer.parseInt(args[8])));
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"region_add", (Object[])new Object[]{arg2});
                ((ProtectionArea)this.getModule()).saveRegions();
                return;
            }
            if (Objects.equals(operation, "remove")) {
                this.checkException(args.length == 2);
                if (!((ProtectionArea)this.getModule()).getRegions().containsKey(arg2)) {
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"region_remove_failed", (Object[])new Object[]{arg2});
                    throw new RuntimeException("???");
                }
                ((ProtectionArea)this.getModule()).getRegions().remove(arg2);
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"region_remove", (Object[])new Object[]{arg2});
            }
        }

        public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
            if (buffer.length == 1) {
                tabList.add("add");
                tabList.add("remove");
                tabList.add("list");
                return;
            }
            block5 : switch (buffer[0]) {
                case "add": {
                    switch (buffer.length) {
                        case 3: {
                            for (World world : Bukkit.getWorlds()) {
                                tabList.add(world.getName().toLowerCase());
                            }
                            break block5;
                        }
                        case 4: 
                        case 7: {
                            tabList.add(sender instanceof Player ? String.valueOf(((Player)sender).getLocation().getBlockX()) : "0");
                            break;
                        }
                        case 5: 
                        case 8: {
                            tabList.add(sender instanceof Player ? String.valueOf(((Player)sender).getLocation().getBlockY()) : "0");
                            break;
                        }
                        case 6: 
                        case 9: {
                            tabList.add(sender instanceof Player ? String.valueOf(((Player)sender).getLocation().getBlockZ()) : "0");
                        }
                    }
                    break;
                }
                case "remove": {
                    if (buffer.length != 2) {
                        return;
                    }
                    tabList.addAll(((ProtectionArea)this.getModule()).getRegions().keySet());
                    break;
                }
                case "record": {
                    if (buffer.length + 1 > 2) {
                        return;
                    }
                    tabList.add("true");
                    tabList.add("false");
                }
            }
        }
    }
}

