/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.security;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import me.gb2022.commons.math.AABB;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.quark.security.WESessionTrackService;
import org.atcraftmc.quark.security.event.WEAction;
import org.atcraftmc.quark.security.event.WESessionEditEvent;
import org.atcraftmc.quark.security.event.WESessionPreEditEvent;
import org.atcraftmc.quark.security.event.WESessionSelectEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.data.record.RecordEntry;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.foundation.region.SimpleRegion;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.2.5")
@AutoRegister(value={"qb:el"})
public final class WESessionSizeLimit
extends PackageModule {
    @Inject(value="!quark.we.size.bypass")
    public Permission bypassCheck;
    @Inject
    private LanguageEntry language;
    @Inject(value="we-size-limit;Time,Player,Action,X,Y,Z,Limit")
    private RecordEntry record;

    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requirePlugin((String)"WorldEdit");
    }

    @EventHandler
    public void onSelect(WESessionPreEditEvent event) {
        int limit = ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"max-selection-size");
        AABB box = event.getRegion().asAABB();
        double x = box.x1 - box.x0;
        double y = box.y1 - box.y0;
        double z = box.z1 - box.z0;
        if (x <= (double)limit && y <= (double)limit && z <= (double)limit) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasPermission(this.bypassCheck)) {
            if (event.getStage() == EditSession.Stage.BEFORE_CHANGE) {
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)player, (String)"select-limited-warn", (Object[])new Object[]{x, y, z, limit});
            }
            return;
        }
        if (event.getStage() == EditSession.Stage.BEFORE_CHANGE) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)player, (String)"select-limited", (Object[])new Object[]{x, y, z, limit});
        }
        event.setCancelled(true);
        this.record.addLine(new Object[]{SharedObjects.DATE_FORMAT.format(new Date()), "Select", x, y, z, limit});
    }

    @EventHandler
    public void onSelect(WESessionSelectEvent event) {
        if (event.getRegion() == null) {
            return;
        }
        AABB box = event.getRegion().asAABB();
        int limit = ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"max-selection-size");
        double x = box.x1 - box.x0;
        double y = box.y1 - box.y0;
        double z = box.z1 - box.z0;
        if (x <= (double)limit && y <= (double)limit && z <= (double)limit) {
            return;
        }
        MessageAccessor.send((LanguageEntry)this.language, (CommandSender)event.getPlayer(), (String)"select-limited-warn", (Object[])new Object[]{x, y, z, limit});
    }

    @EventHandler
    public void onEdit(WESessionEditEvent event) {
        if (WESessionTrackService.getLatestAction(event.getPlayer()) != WEAction.STACK) {
            return;
        }
        Player player = event.getPlayer();
        boolean cancel = !player.hasPermission(this.bypassCheck);
        int limit = ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"max-edit-size");
        SimpleRegion region = WESessionTrackService.getRegion(player);
        AABB aabb = region.asAABB();
        int cx = (int)aabb.getCenter().x();
        int cy = (int)aabb.getCenter().y();
        int cz = (int)aabb.getCenter().z();
        double w = aabb.x1 - aabb.x0;
        double h = aabb.y1 - aabb.y0;
        double d = aabb.z1 - aabb.z0;
        Extent wrapped = event.getMask();
        RadiusLimitedExtent wrapper = new RadiusLimitedExtent(wrapped, cx, cy, cz, limit, cancel);
        wrapper.addAnnounce(() -> {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)player, (String)(cancel ? "edit-limited" : "edit-limited-warn"), (Object[])new Object[]{limit});
            this.record.addLine(new Object[]{SharedObjects.DATE_FORMAT.format(new Date()), "Edit", w, h, d, limit});
        });
        event.setMask(wrapper);
    }

    public static final class RadiusLimitedExtent
    implements Extent {
        private final List<Consumer<Vector3i>> callbacks = new ArrayList<Consumer<Vector3i>>();
        private final List<Runnable> announces = new ArrayList<Runnable>();
        private final Extent wrapped;
        private final int centerX;
        private final int centerY;
        private final int centerZ;
        private final int radius;
        private final boolean cancelAction;
        private boolean isAnnounced = false;

        public RadiusLimitedExtent(Extent wrapped, int centerX, int centerY, int centerZ, int radius, boolean cancelAction) {
            this.wrapped = wrapped;
            this.centerX = centerX;
            this.centerY = centerY;
            this.centerZ = centerZ;
            this.radius = radius;
            this.cancelAction = cancelAction;
        }

        @SafeVarargs
        public final void addCallback(Consumer<Vector3i> ... callbacks) {
            this.callbacks.addAll(List.of(callbacks));
        }

        public void addAnnounce(Runnable ... announces) {
            this.announces.addAll(List.of(announces));
        }

        private boolean isInvalidPosition(int x, int y, int z) {
            int x0 = this.centerX - this.radius;
            int y0 = this.centerY - this.radius;
            int z0 = this.centerZ - this.radius;
            int x1 = this.centerX + this.radius;
            int y1 = this.centerY + this.radius;
            int z1 = this.centerZ + this.radius;
            return x < x0 || x > x1 || y < y0 || y > y1 || z < z0 || z > z1;
        }

        private void sendInvalid(int x, int y, int z) {
            Vector3i p = new Vector3i(x, y, z);
            for (Consumer<Vector3i> cb : this.callbacks) {
                cb.accept(p);
            }
            if (this.isAnnounced) {
                return;
            }
            for (Runnable an : this.announces) {
                an.run();
            }
            this.isAnnounced = true;
        }

        public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 position, T block) throws WorldEditException {
            int z;
            int y;
            int x = position.getBlockX();
            if (this.isInvalidPosition(x, y = position.getBlockY(), z = position.getBlockZ())) {
                this.sendInvalid(x, y, z);
                if (this.cancelAction) {
                    return false;
                }
            }
            return this.wrapped.setBlock(position, block);
        }

        @Nullable
        public Entity createEntity(Location location, BaseEntity entity) {
            int z;
            int y;
            int x = location.getBlockX();
            if (this.isInvalidPosition(x, y = location.getBlockY(), z = location.getBlockZ())) {
                this.sendInvalid(x, y, z);
                if (this.cancelAction) {
                    return null;
                }
            }
            return this.wrapped.createEntity(location, entity);
        }

        @Nullable
        public Operation commit() {
            return this.wrapped.commit();
        }

        public BlockState getBlock(BlockVector3 position) {
            int z;
            int y;
            int x = position.getBlockX();
            if (this.isInvalidPosition(x, y = position.getBlockY(), z = position.getBlockZ())) {
                assert (BlockTypes.AIR != null);
                return BlockTypes.AIR.getDefaultState();
            }
            return this.wrapped.getBlock(position);
        }

        public BaseBlock getFullBlock(BlockVector3 position) {
            return this.getBlock(position).toBaseBlock();
        }

        public BlockVector3 getMinimumPoint() {
            return BlockVector3.ZERO;
        }

        public BlockVector3 getMaximumPoint() {
            return BlockVector3.ZERO;
        }

        public List<? extends Entity> getEntities(Region region) {
            return this.wrapped.getEntities(region);
        }

        public List<? extends Entity> getEntities() {
            return this.wrapped.getEntities();
        }
    }
}

