/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.security;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.command.tool.SelectionWand;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.event.platform.BlockInteractEvent;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.PlayerInputEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.NullExtent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.eventbus.EventHandler;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.world.World;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.quark.security.event.WEAction;
import org.atcraftmc.quark.security.event.WESessionEditEvent;
import org.atcraftmc.quark.security.event.WESessionPreEditEvent;
import org.atcraftmc.quark.security.event.WESessionSelectEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.BukkitUtil;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.foundation.region.SimpleRegion;
import org.tbstcraft.quark.framework.service.QuarkService;
import org.tbstcraft.quark.framework.service.Service;
import org.tbstcraft.quark.framework.service.ServiceHolder;
import org.tbstcraft.quark.framework.service.ServiceInject;
import org.tbstcraft.quark.framework.service.ServiceProvider;

@QuarkService(id="we-session-track")
public interface WESessionTrackService
extends Service {
    @ServiceInject
    public static final ServiceHolder<WESessionTrackService> INSTANCE = new ServiceHolder();

    public static SimpleRegion getRegion(org.bukkit.entity.Player p) {
        return ((WESessionTrackService)INSTANCE.get()).getPlayerRegion(p);
    }

    public static SimpleRegion getRegionNatively(org.bukkit.entity.Player p) {
        return ((WESessionTrackService)INSTANCE.get()).getPlayerRegionNatively(p);
    }

    public static WEAction getLatestAction(org.bukkit.entity.Player player) {
        return ((WESessionTrackService)INSTANCE.get()).getPlayerLatestAction(player);
    }

    @ServiceProvider
    public static WESessionTrackService create(ConfigEntry cfg) {
        return new ServiceImplementation();
    }

    public SimpleRegion getPlayerRegion(org.bukkit.entity.Player var1);

    public SimpleRegion getPlayerRegionNatively(org.bukkit.entity.Player var1);

    public WEAction getPlayerLatestAction(org.bukkit.entity.Player var1);

    public static final class ServiceImplementation
    implements WESessionTrackService,
    Listener {
        private final Map<org.bukkit.entity.Player, SimpleRegion> regions = new HashMap<org.bukkit.entity.Player, SimpleRegion>();
        private final Map<org.bukkit.entity.Player, WEAction> latestActions = new HashMap<org.bukkit.entity.Player, WEAction>();

        public void onEnable() {
            WorldEdit.getInstance().getEventBus().register((Object)this);
            BukkitUtil.registerEventListener((Listener)this);
        }

        public void onDisable() {
            WorldEdit.getInstance().getEventBus().unregister((Object)this);
            BukkitUtil.unregisterEventListener((Listener)this);
        }

        public void checkCompatibility() throws APIIncompatibleException {
            Compatibility.requirePlugin((String)"WorldEdit");
            Compatibility.requireClass(() -> Class.forName("com.sk89q.worldedit.util.HandSide"));
        }

        @Override
        public SimpleRegion getPlayerRegion(org.bukkit.entity.Player p) {
            if (!this.regions.containsKey(p) || this.regions.get(p) == null) {
                this.regions.put(p, this.getPlayerRegionNatively(p));
            }
            return this.regions.get(p);
        }

        @Override
        public WEAction getPlayerLatestAction(org.bukkit.entity.Player p) {
            return this.latestActions.get(p);
        }

        @Override
        public SimpleRegion getPlayerRegionNatively(org.bukkit.entity.Player p) {
            BukkitPlayer player = BukkitAdapter.adapt((org.bukkit.entity.Player)p);
            World world = BukkitAdapter.adapt((org.bukkit.World)p.getWorld());
            try {
                Region r = WorldEdit.getInstance().getSessionManager().get((SessionOwner)player).getSelection(world);
                int x0 = r.getMinimumPoint().getBlockX();
                int y0 = r.getMinimumPoint().getBlockY();
                int z0 = r.getMinimumPoint().getBlockZ();
                int x1 = r.getMaximumPoint().getBlockX();
                int y1 = r.getMaximumPoint().getBlockY();
                int z1 = r.getMaximumPoint().getBlockZ();
                return new SimpleRegion(p.getWorld(), x0, y0, z0, x1, y1, z1);
            }
            catch (IncompleteRegionException e) {
                return null;
            }
        }

        @Subscribe(priority=EventHandler.Priority.VERY_LATE)
        public void handleInput(PlayerInputEvent event) {
            Player p = event.getPlayer();
            LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)p);
            if (!(session.getTool(p.getItemInHand(HandSide.MAIN_HAND).getType()) instanceof SelectionWand)) {
                return;
            }
            event.setCancelled(true);
        }

        @Subscribe(priority=EventHandler.Priority.VERY_LATE)
        public void handleBlockInput(BlockInteractEvent event) {
            Actor actor = event.getCause();
            if (!(actor instanceof Player)) {
                return;
            }
            Player p = (Player)actor;
            LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)p);
            if (!(session.getTool(p.getItemInHand(HandSide.MAIN_HAND).getType()) instanceof SelectionWand)) {
                return;
            }
            this.handleWEEvent(p);
        }

        @Subscribe(priority=EventHandler.Priority.VERY_LATE)
        public void handleCommand(CommandEvent event) {
            Actor actor = event.getActor();
            if (!(actor instanceof Player)) {
                return;
            }
            Player p = (Player)actor;
            boolean b1 = event.getArguments().startsWith("//pos1");
            boolean b2 = event.getArguments().startsWith("//pos2");
            boolean b11 = event.getArguments().startsWith("//hpos1");
            boolean b12 = event.getArguments().startsWith("//hpos2");
            if (b1 || b2 || b11 || b12) {
                this.handleWEEvent(p);
            }
        }

        @Subscribe(priority=EventHandler.Priority.VERY_EARLY)
        public void onSessionEdit(EditSessionEvent event) {
            if (event.getActor() == null) {
                return;
            }
            org.bukkit.entity.Player player = Bukkit.getPlayer((UUID)event.getActor().getUniqueId());
            if (player == null) {
                return;
            }
            WESessionPreEditEvent e1 = new WESessionPreEditEvent(player, (org.tbstcraft.quark.foundation.region.Region)this.getPlayerRegion(player), event.getStage());
            Bukkit.getPluginManager().callEvent((Event)e1);
            if (e1.isCancelled()) {
                event.setExtent((Extent)new NullExtent());
                return;
            }
            WESessionEditEvent evt = new WESessionEditEvent(player, event.getExtent());
            Bukkit.getPluginManager().callEvent((Event)evt);
            event.setExtent(evt.getMask());
        }

        private void handleWEEvent(Player p) {
            org.bukkit.entity.Player player1 = BukkitAdapter.adapt((Player)p);
            LocalSession session1 = WorldEdit.getInstance().getSessionManager().get((SessionOwner)p);
            World world = p.getWorld();
            try {
                Region region = session1.getSelection(world);
                Location p1 = BukkitAdapter.adapt((org.bukkit.World)player1.getWorld(), (BlockVector3)region.getBoundingBox().getMinimumPoint());
                Location p2 = BukkitAdapter.adapt((org.bukkit.World)player1.getWorld(), (BlockVector3)region.getBoundingBox().getMaximumPoint());
                SimpleRegion r = new SimpleRegion(p1, p2);
                this.regions.put(player1, r);
            }
            catch (IncompleteRegionException region) {
                // empty catch block
            }
            org.bukkit.entity.Player player = Bukkit.getPlayer((UUID)p.getUniqueId());
            WESessionSelectEvent evt = new WESessionSelectEvent(player, (org.tbstcraft.quark.foundation.region.Region)this.getPlayerRegion(player));
            Bukkit.getPluginManager().callEvent((Event)evt);
        }

        @EventHandler
        public void onPlayerCommand(PlayerCommandPreprocessEvent e) {
            if (e.getMessage().startsWith("//stack") || e.getMessage().startsWith("/worldedit:/stack")) {
                this.latestActions.put(e.getPlayer(), WEAction.STACK);
                return;
            }
            if (e.getMessage().startsWith("//paste") || e.getMessage().startsWith("/worldedit:/paste")) {
                this.latestActions.put(e.getPlayer(), WEAction.PASTE);
                return;
            }
            if (e.getMessage().startsWith("//set") || e.getMessage().startsWith("/worldedit:/set")) {
                this.latestActions.put(e.getPlayer(), WEAction.FILL);
                return;
            }
            this.latestActions.put(e.getPlayer(), WEAction.OTHER);
        }
    }
}

