/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.utilities;

import java.util.Stack;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.LanguageItem;
import org.bukkit.command.CommandSender;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.0.0")
@QuarkCommand(name="calc")
public final class Calculator
extends CommandModule {
    @Inject(value="tip")
    private LanguageItem tip;

    public void enable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tip));
        super.enable();
    }

    public void disable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tip));
        super.disable();
    }

    public static double calculate(String expression) {
        char[] tokens = expression.toCharArray();
        Stack<Double> values = new Stack<Double>();
        Stack<Character> operators = new Stack<Character>();
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i] == ' ') continue;
            if (Character.isDigit(tokens[i])) {
                StringBuilder sb = new StringBuilder();
                while (i < tokens.length && (Character.isDigit(tokens[i]) || tokens[i] == '.')) {
                    sb.append(tokens[i++]);
                }
                values.push(Double.parseDouble(sb.toString()));
                --i;
                continue;
            }
            if (tokens[i] == '(') {
                operators.push(Character.valueOf(tokens[i]));
                continue;
            }
            if (tokens[i] == ')') {
                while (((Character)operators.peek()).charValue() != '(') {
                    values.push(Calculator.applyOperator(((Character)operators.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
                }
                operators.pop();
                continue;
            }
            if (tokens[i] != '+' && tokens[i] != '-' && tokens[i] != '*' && tokens[i] != '/') continue;
            while (!operators.isEmpty() && Calculator.hasPrecedence(tokens[i], ((Character)operators.peek()).charValue())) {
                values.push(Calculator.applyOperator(((Character)operators.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
            }
            operators.push(Character.valueOf(tokens[i]));
        }
        while (!operators.isEmpty()) {
            values.push(Calculator.applyOperator(((Character)operators.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
        }
        return (Double)values.pop();
    }

    private static boolean hasPrecedence(char op1, char op2) {
        return op2 != '(' && op2 != ')' && Calculator.getPrecedence(op1) <= Calculator.getPrecedence(op2);
    }

    private static int getPrecedence(char operator) {
        return switch (operator) {
            case '+', '-' -> 1;
            case '*', '/' -> 2;
            default -> -1;
        };
    }

    private static double applyOperator(char operator, double b, double a) {
        return switch (operator) {
            case '+' -> a + b;
            case '-' -> a - b;
            case '*' -> a * b;
            case '/' -> {
                if (b == 0.0) {
                    throw new ArithmeticException("Cannot divide by zero");
                }
                yield a / b;
            }
            default -> 0.0;
        };
    }

    public void execute(CommandExecution context) {
        String exp = context.requireArgumentAt(0);
        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)context.getSender(), (String)"calc", (Object[])new Object[]{exp, Calculator.calculate(exp)});
    }
}

