/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.utilities;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import me.gb2022.commons.math.LinearInterpolation;
import me.gb2022.commons.reflect.AutoRegister;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.0.0")
@QuarkCommand(name="camera", permission="-quark.camera", playerOnly=true)
@AutoRegister(value={"qb:el"})
public final class CameraMovement
extends CommandModule {
    public static final int INVALID_ROTATION = -1145141919;

    public void onCommand(CommandSender sender, String[] args) {
        int yr2;
        int xr2;
        int yr1;
        int xr1;
        int z2;
        int y2;
        int x2;
        int z1;
        int y1;
        int x1;
        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"cam-start", (Object[])new Object[]{args[0]});
        Player player = (Player)sender;
        String tid = "quark:camera-" + UUID.randomUUID();
        int length = Integer.parseInt(args[0]);
        if (args.length > 7) {
            x1 = Integer.parseInt(args[1]);
            y1 = Integer.parseInt(args[2]);
            z1 = Integer.parseInt(args[3]);
            x2 = Integer.parseInt(args[6]);
            y2 = Integer.parseInt(args[7]);
            z2 = Integer.parseInt(args[8]);
            xr1 = Integer.parseInt(args[4]);
            yr1 = Integer.parseInt(args[5]);
            xr2 = Integer.parseInt(args[9]);
            yr2 = Integer.parseInt(args[10]);
        } else {
            x1 = Integer.parseInt(args[1]);
            y1 = Integer.parseInt(args[2]);
            z1 = Integer.parseInt(args[3]);
            x2 = Integer.parseInt(args[4]);
            y2 = Integer.parseInt(args[5]);
            z2 = Integer.parseInt(args[6]);
            xr2 = -1145141919;
            yr2 = -1145141919;
            xr1 = -1145141919;
            yr1 = -1145141919;
        }
        boolean useRotation = xr1 != -1145141919;
        TaskService.global().timer(tid, 1L, 1L, (Runnable)new CameraTask(player, length, tid, useRotation, useRotation, t -> {
            double x = LinearInterpolation.do1((double)x1, (double)x2, (double)t);
            double y = LinearInterpolation.do1((double)y1, (double)y2, (double)t);
            double z = LinearInterpolation.do1((double)z1, (double)z2, (double)t);
            double xr = LinearInterpolation.do1((double)xr1, (double)xr2, (double)t);
            double yr = LinearInterpolation.do1((double)yr1, (double)yr2, (double)t);
            Location tt = new Location(player.getWorld(), x, y, z);
            tt.setYaw((float)xr);
            tt.setPitch((float)yr);
            return tt;
        }));
    }

    public Location bezier(double t, Location start, Location end, Location ... controls) {
        ArrayList<Location> points = new ArrayList<Location>();
        points.add(start);
        points.addAll(List.of(controls));
        points.add(end);
        while (points.size() > 1) {
            ArrayList<Location> newPoints = new ArrayList<Location>();
            for (int i = 0; i < points.size() - 1; ++i) {
                Location p0 = (Location)points.get(i);
                Location p1 = (Location)points.get(i + 1);
                double x = (1.0 - t) * p0.getX() + t * p1.getX();
                double y = (1.0 - t) * p0.getY() + t * p1.getY();
                double z = (1.0 - t) * p0.getZ() + t * p1.getZ();
                newPoints.add(new Location(p0.getWorld(), x, y, z));
            }
            points = newPoints;
        }
        return (Location)points.get(0);
    }

    public static final class CameraTask
    implements Runnable {
        private final Player viewer;
        private final int ticks;
        private final Function<Double, Location> callback;
        private final String tid;
        private final Location lastLocation;
        private final GameMode lastGameMode;
        private final boolean applyRotation;
        private int tick = 0;

        public CameraTask(Player viewer, int ticks, String tid, boolean applyRotation, boolean alignRotation, Function<Double, Location> callback) {
            this.viewer = viewer;
            this.ticks = ticks;
            this.callback = callback;
            this.tid = tid;
            this.lastLocation = viewer.getLocation();
            this.lastGameMode = viewer.getGameMode();
            this.applyRotation = applyRotation;
            Location start = callback.apply(0.0);
            if (!alignRotation) {
                start.setYaw(viewer.getLocation().getYaw());
                start.setPitch(viewer.getLocation().getPitch());
            }
            viewer.setGameMode(GameMode.SPECTATOR);
            viewer.teleport(start);
        }

        @Override
        public void run() {
            if (this.tick > this.ticks) {
                TaskService.global().cancel(this.tid);
                this.viewer.teleport(this.lastLocation);
                this.viewer.setGameMode(this.lastGameMode);
                return;
            }
            double t1 = (double)this.tick / (double)this.ticks;
            double t2 = (double)(this.tick + 1) / (double)this.ticks;
            Location interpolatedLocation = this.callback.apply(t1);
            Location nextInterpolatedLocation = this.callback.apply(t2);
            Vector direction = nextInterpolatedLocation.toVector().subtract(interpolatedLocation.toVector());
            this.viewer.setVelocity(direction.multiply(1));
            if (this.applyRotation) {
                try {
                    this.viewer.setRotation(interpolatedLocation.getYaw(), interpolatedLocation.getPitch());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++this.tick;
        }
    }
}

