/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import me.gb2022.apm.local.PluginMessenger;
import me.gb2022.commons.nbt.NBTTagCompound;
import me.gb2022.commons.reflect.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.tbstcraft.quark.data.ModuleDataService;
import org.tbstcraft.quark.data.assets.Asset;
import org.tbstcraft.quark.foundation.platform.APIProfile;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.0.0", compatBlackList={APIProfile.BUKKIT, APIProfile.SPIGOT, APIProfile.ARCLIGHT}, defaultEnable=false)
@QuarkCommand(name="log-format", permission="-quark.logformat")
public final class CustomLogFormat
extends CommandModule {
    @Inject(value="log.xml;false")
    private Asset logAsset;
    @Inject
    private LanguageEntry language;

    public void enable() {
        super.enable();
        this.logger = this.createLogger();
        NBTTagCompound tag = ModuleDataService.getEntry((String)this.getId());
        if (!tag.hasKey("enable")) {
            tag.setBoolean("enable", true);
            ModuleDataService.save((String)this.getId());
        }
        if (tag.getBoolean("enable")) {
            this.setFormat();
        }
    }

    public void setFormat() {
        this.setLoggerFormat(this.logAsset.asURL());
    }

    public boolean setLoggerFormat(URL resource) {
        if (resource == null) {
            return false;
        }
        try {
            InputStream stream = resource.openStream();
            if (stream == null) {
                return false;
            }
            stream.readAllBytes();
            stream.close();
        }
        catch (IOException e) {
            return false;
        }
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        try {
            context.setConfigLocation(resource.toURI());
        }
        catch (URISyntaxException e) {
            return false;
        }
        context.reconfigure();
        PluginMessenger.broadcastListed((String)"quark:log:reconfigure", List.of());
        return true;
    }

    public void restoreFormatFile() {
        this.logAsset.save();
        this.logger.info("covered log file.");
    }

    public void setDataEnable(boolean enable) {
        NBTTagCompound tag = ModuleDataService.getEntry((String)this.getId());
        if (tag.hasKey("enable")) {
            tag.setBoolean("enable", enable);
            ModuleDataService.save((String)this.getId());
        }
    }

    public void onCommand(CommandSender sender, String[] args) {
        switch (args[0]) {
            case "reload": {
                this.setFormat();
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"reload", (Object[])new Object[0]);
                break;
            }
            case "restore": {
                this.restoreFormatFile();
                this.setFormat();
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"restore", (Object[])new Object[0]);
                break;
            }
            case "on": {
                this.setDataEnable(true);
                this.setFormat();
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"enable", (Object[])new Object[0]);
                break;
            }
            case "off": {
                this.setDataEnable(false);
                if (!this.setLoggerFormat(Bukkit.class.getResource("/log4j2.xml"))) {
                    this.logger.severe("failed to inject log format, consider checking resource.");
                }
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"disable", (Object[])new Object[0]);
            }
        }
    }

    public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
        if (buffer.length != 1) {
            return;
        }
        tabList.add("reload");
        tabList.add("restore");
        tabList.add("on");
        tabList.add("off");
    }
}

