/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.utilities;

import java.util.ArrayList;
import java.util.List;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.assertion.NumberLimitation;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandExecutor;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.LanguageItem;
import org.atcraftmc.quark.utilities.viewdistance.CustomSettingStrategy;
import org.atcraftmc.quark.utilities.viewdistance.PlayerCountStrategy;
import org.atcraftmc.quark.utilities.viewdistance.ViewDistanceStrategy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permission;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.command.QuarkCommandExecutor;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.MessageAccessor;

@AutoRegister(value={"qb:el"})
@CommandProvider(value={ViewDistanceCommand.class})
@QuarkModule(version="1.0.0")
public final class DynamicViewDistance
extends PackageModule
implements QuarkCommandExecutor {
    private final List<ViewDistanceStrategy> pipeline = new ArrayList<ViewDistanceStrategy>();
    @Inject
    private LanguageEntry language;
    @Inject(value="-quark.viewdistance.other")
    private Permission setOtherPermission;
    @Inject(value="tip")
    private LanguageItem tip;

    public void enable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tip));
        this.pipeline.add(new PlayerCountStrategy());
        this.pipeline.add(new CustomSettingStrategy());
        TaskService.async().timer("view-distance:calc", 1L, 20L, () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.calculatePlayerViewDistance(p, false, false);
            }
        });
    }

    public void checkCompatibility() {
        Compatibility.requireMethod(() -> Player.class.getMethod("setSendViewDistance", Integer.TYPE));
        Compatibility.requireMethod(() -> Player.class.getMethod("setViewDistance", Integer.TYPE));
        Compatibility.requireMethod(() -> Player.class.getMethod("getLastLogin", new Class[0]));
    }

    public void disable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tip));
        TaskService.async().cancel("view-distance:calc");
        int val = Bukkit.getViewDistance();
        for (Player p : Bukkit.getOnlinePlayers()) {
            try {
                p.setViewDistance(val);
                p.setSendViewDistance(val);
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        TaskService.global().delay(10L, () -> this.calculatePlayerViewDistance(event.getPlayer(), true, false));
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        int val = Bukkit.getViewDistance();
        event.getPlayer().setViewDistance(val);
        event.getPlayer().setSendViewDistance(val);
    }

    public void calculatePlayerViewDistance(Player player, boolean remind, boolean forceRemind) {
        int value = Bukkit.getViewDistance();
        boolean programRemind = false;
        for (ViewDistanceStrategy strategy : this.pipeline) {
            value = strategy.determine(player, value);
            programRemind = strategy.remindPlayer(player, programRemind);
        }
        value = Math.max(2, Math.min(32, value));
        if (programRemind && remind || forceRemind) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)player, (String)"set-self", (Object[])new Object[]{value});
        }
        player.setViewDistance(value);
        player.setSendViewDistance(value);
    }

    public void execute(CommandExecution context) {
        Player player;
        String[] args = context.getArgs();
        CommandSender sender = context.getSender();
        int value = context.requireIntegerOrElse(0, -1, new NumberLimitation[]{NumberLimitation.bound((double)2.0, (double)32.0)});
        if (context.hasArgumentAt(1)) {
            context.requirePermission(this.setOtherPermission);
            player = context.requirePlayer(1);
        } else {
            player = context.requireSenderAsPlayer();
        }
        boolean isSelf = sender.getName().equals(player.getName());
        if (value == -1) {
            CustomSettingStrategy.clear(player);
            if (!isSelf) {
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"reset-target", (Object[])new Object[]{args[0]});
            }
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)player, (String)"reset-self", (Object[])new Object[0]);
            this.calculatePlayerViewDistance(player, false, false);
            return;
        }
        CustomSettingStrategy.set(player, value);
        if (!isSelf) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"set-target", (Object[])new Object[]{args[1], value});
        }
        MessageAccessor.send((LanguageEntry)this.language, (CommandSender)player, (String)"set-self", (Object[])new Object[]{value});
        this.calculatePlayerViewDistance(player, false, false);
    }

    public void suggest(CommandSuggestion suggestion) {
        suggestion.suggest(0, new String[]{"2", "4", "8", "16", "24", "32", "reset"});
        suggestion.requireAnyPermission(s -> s.suggestPlayers(1), new Permission[]{this.setOtherPermission});
    }

    @QuarkCommand(name="view-distance", permission="+quark.viewdistance")
    public static final class ViewDistanceCommand
    extends ModuleCommand<DynamicViewDistance> {
        public void init(DynamicViewDistance module) {
            this.setExecutor((CommandExecutor)module);
        }
    }
}

