/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.utilities;

import java.util.Collection;
import java.util.function.Consumer;
import me.gb2022.commons.reflect.AutoRegister;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.assertion.NumberLimitation;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.command.select.EntitySelector;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.task.Task;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule
@AutoRegister(value={"qb:el"})
@QuarkCommand(name="motion", permission="-quark.util.motion")
public final class EntityMotion
extends CommandModule {
    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requireMethod(() -> Location.class.getDeclaredMethod("getNearbyEntities", Double.TYPE, Double.TYPE, Double.TYPE));
    }

    public void suggest(CommandSuggestion suggestion) {
        EntitySelector.tab((CommandSuggestion)suggestion, (int)0);
        suggestion.suggest(1, new String[]{"add", "set"});
        suggestion.suggest(2, new String[]{"[time]", "1", "5", "10"});
        suggestion.suggest(3, new String[]{"[x]", "0", "1.0", "-1.0"});
        suggestion.suggest(4, new String[]{"[y]", "0", "1.0", "-1.0"});
        suggestion.suggest(5, new String[]{"[z]", "0", "1.0", "-1.0"});
    }

    public void execute(CommandExecution context) {
        Collection target = EntitySelector.selectEntity((CommandExecution)context, (int)0);
        String mode = context.requireEnum(1, new String[]{"add", "set"});
        boolean add = mode.equals("add");
        int time = context.requireArgumentInteger(2, new NumberLimitation[0]);
        double x = context.requireArgumentDouble(3, new NumberLimitation[0]);
        double y = context.requireArgumentDouble(4, new NumberLimitation[0]);
        double z = context.requireArgumentDouble(5, new NumberLimitation[0]);
        Vector vector = new Vector(x, y, z);
        for (CommandSender p : target) {
            this.attempt((Entity)p, time, vector, add);
        }
        if (!(context.getSender() instanceof Player)) {
            return;
        }
        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)context.getSender(), (String)"hint", (Object[])new Object[]{target.size(), time, mode, x, y, z});
    }

    private void attempt(final Entity e, final int time, final Vector value, final boolean add) {
        if (e.getVehicle() != null) {
            this.attempt(e.getVehicle(), time, value, add);
        }
        TaskService.entity((Entity)e).timer(1L, 1L, (Consumer)new Consumer<Task>(){
            private int tick = 0;

            @Override
            public void accept(Task task) {
                ++this.tick;
                if (this.tick > time) {
                    task.cancel();
                }
                e.setVelocity(add ? e.getVelocity().add(value) : value);
            }
        });
    }
}

