/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;

@QuarkModule(defaultEnable=false, description="FRPC service holder")
public final class FrpcHolder
extends PackageModule {
    private Process process;

    public void enable() {
        String cmd = this.getConfig().value("command").string();
        String path = this.getConfig().value("path").string();
        try {
            this.process = new ProcessBuilder(new String[0]).directory(new File(path)).command(cmd).start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        TaskService.async().run("quark:frpc:daemon", () -> {
            try {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        this.getL4jLogger().info("[frpc] {}", (Object)line);
                    }
                }
                this.process.waitFor();
            }
            catch (Exception e) {
                this.getL4jLogger().catching((Throwable)e);
            }
            TaskService.async().delay(20L, this::enable);
        });
    }

    public void disable() {
        TaskService.async().cancel("quark:frpc:daemon");
        this.process.destroyForcibly();
    }
}

