/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.utilities;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.apache.logging.log4j.Logger;
import org.atcraftmc.qlib.command.AbstractCommand;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.language.LanguageItem;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import org.tbstcraft.quark.Quark;
import org.tbstcraft.quark.data.assets.AssetGroup;
import org.tbstcraft.quark.framework.customcontent.CustomMeta;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.permission.PermissionService;
import org.tbstcraft.quark.internal.ui.IconRenderer;
import org.tbstcraft.quark.internal.ui.InventoryUI;
import org.tbstcraft.quark.internal.ui.LoreRenderer;
import org.tbstcraft.quark.internal.ui.TextRenderer;
import org.tbstcraft.quark.internal.ui.UI;
import org.tbstcraft.quark.internal.ui.element.ElementCallback;
import org.tbstcraft.quark.internal.ui.view.InventoryUIView;

@QuarkModule
@AutoRegister(value={"qb:el"})
@QuarkCommand(name="gui", permission="-quark.gui.admin")
public class InventoryMenu
extends CommandModule {
    private final Map<String, MenuData> menus = new HashMap<String, MenuData>();
    private final Map<String, Component> components = new HashMap<String, Component>();
    @Inject(value="ui")
    private AssetGroup assets;
    @Inject
    private Logger logger;

    public static TextRenderer text(ConfigurationSection section) {
        return InventoryMenu.text(section.getValues(false));
    }

    public static TextRenderer text(Map<String, ?> section) {
        if (section.containsKey("text")) {
            return TextRenderer.literal((net.kyori.adventure.text.Component)TextBuilder.buildComponent((String)section.get("text").toString(), (net.kyori.adventure.text.Component[])new net.kyori.adventure.text.Component[0]));
        }
        if (section.containsKey("lang")) {
            String[] key = Objects.requireNonNull(section.get("lang").toString()).split(":");
            return TextRenderer.data((LanguageItem)Quark.lang().item(key[0], key[1], key[2]), (Object[])new Object[0]);
        }
        throw new IllegalArgumentException("unexpected text component");
    }

    public static ElementCallback operations(List<String> list) {
        ElementCallback[] result = new ElementCallback[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String line;
            String encoded = list.get(i);
            if (encoded.startsWith("[close]")) {
                result[i] = UI.close();
                continue;
            }
            if (encoded.startsWith("[command]")) {
                line = encoded.substring(10);
                result[i] = UI.command((Function)UI.value((String)line));
                continue;
            }
            if (encoded.startsWith("[sound]")) {
                line = encoded.substring(7);
                Sound sound = Sound.valueOf((String)line.replace(".", "_").toUpperCase());
                result[i] = UI.sound((Sound)sound, (int)1);
            }
            if (!encoded.startsWith("[connect]")) continue;
            line = encoded.substring(9);
            result[i] = UI.connect((Function)UI.value((String)line));
        }
        return UI.forwarding((ElementCallback[])result);
    }

    public static IconRenderer icon(ConfigurationSection section) {
        String type = section.getString("type");
        int amount = section.contains("amount") ? Integer.parseInt((String)section.get("amount")) : 1;
        Material material = Material.getMaterial((String)Objects.requireNonNull(type).toUpperCase());
        ItemStack stack = section.getBoolean("enchanted", false) ? UI.enchanted((Material)material) : UI.icon((Material)material);
        CustomMeta.setItemPDCIdentifier((ItemStack)stack, (String)"quark::menu");
        stack.setAmount(amount);
        return v -> stack;
    }

    public static ElementCallback callbacks(final ConfigurationSection component) {
        ElementCallback left = new ElementCallback(){
            private final ElementCallback data;
            {
                this.data = InventoryMenu.operations(component.getStringList("left-click"));
            }

            public void click(InventoryUIView view, Player player, InventoryAction action) {
                if (action == InventoryAction.PICKUP_ALL) {
                    this.data.click(view, player, action);
                }
            }
        };
        ElementCallback right = new ElementCallback(){
            private final ElementCallback data;
            {
                this.data = InventoryMenu.operations(component.getStringList("right-click"));
            }

            public void click(InventoryUIView view, Player player, InventoryAction action) {
                if (action == InventoryAction.PICKUP_HALF) {
                    this.data.click(view, player, action);
                }
            }
        };
        ElementCallback both = InventoryMenu.operations(component.getStringList("any-click"));
        return UI.forwarding((ElementCallback[])new ElementCallback[]{left, right, both});
    }

    public static LoreRenderer lore(List<?> list) {
        if (list.isEmpty()) {
            return LoreRenderer.none();
        }
        TextRenderer[] result = new TextRenderer[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Object sect = list.get(i);
            result[i] = InventoryMenu.text((Map)sect);
        }
        return LoreRenderer.forwarding((TextRenderer[])result);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        PlayerInventory inv = event.getPlayer().getInventory();
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack item = inv.getItem(i);
            if (item == null || !Objects.equals(CustomMeta.getItemPDCIdentifier((ItemStack)item), "quark::menu")) continue;
            inv.setItem(i, null);
        }
    }

    public void load() {
        this.unload();
        ArrayList data = new ArrayList(this.assets.list());
        data.sort(Comparator.naturalOrder());
        for (String fileName : data) {
            YamlConfiguration dom = new YamlConfiguration();
            try {
                dom.loadFromString(this.assets.asText(fileName));
            }
            catch (InvalidConfigurationException e) {
                this.logger.warn("Attempt to load invalid configuration!");
                this.logger.catching((Throwable)e);
            }
            if (Objects.requireNonNull(dom.getRoot()).contains("menu")) {
                this.loadPage(Objects.requireNonNull(dom.getConfigurationSection("menu")), fileName);
                continue;
            }
            if (!Objects.requireNonNull(dom.getRoot()).contains("components")) continue;
            this.loadComponents(Objects.requireNonNull(dom.getConfigurationSection("components")), fileName);
        }
        for (MenuData md : this.menus.values()) {
            md.register();
        }
    }

    public void unload() {
        for (MenuData md : this.menus.values()) {
            md.destroy();
        }
        this.components.clear();
        this.menus.clear();
    }

    public void save() {
        this.assets.save("m_example-menu.yml");
        this.assets.save("m_warp-menu.yml");
        this.assets.save("m_view-distance-selector.yml");
        this.assets.save("c_default-components.yml");
    }

    public void enable() {
        if (!this.assets.existFolder()) {
            this.save();
        }
        super.enable();
        this.load();
    }

    public void disable() {
        super.disable();
        this.unload();
    }

    public void loadPage(ConfigurationSection sect, String file) {
        try {
            String id = sect.getString("id");
            int capacity = sect.getInt("capacity");
            String perm = sect.getString("permission", "");
            List commands = sect.getStringList("commands");
            TextRenderer title = InventoryMenu.text(Objects.requireNonNull(sect.getConfigurationSection("title")));
            ElementCallback open = InventoryMenu.operations(sect.getStringList("open"));
            InventoryUI ui = new InventoryUI(capacity, title, open);
            Permission permission = perm.isEmpty() ? null : PermissionService.getPermission((String)perm);
            this.menus.put(id, new MenuData(ui, permission, commands));
            ConfigurationSection components = Objects.requireNonNull(sect.getConfigurationSection("components"));
            for (String idx : components.getKeys(false)) {
                for (String pos : idx.split(",")) {
                    if (components.isString(idx)) {
                        this.components.get(components.getString(idx)).build(ui, Integer.parseInt(pos));
                        continue;
                    }
                    ConfigurationSection section = Objects.requireNonNull(components.getConfigurationSection(idx));
                    UI.buildComponent((InventoryUI)ui, (int)Integer.parseInt(pos), b -> {
                        b.icon(InventoryMenu.icon(Objects.requireNonNull(section.getConfigurationSection("icon"))));
                        b.name(InventoryMenu.text(Objects.requireNonNull(section.getConfigurationSection("name"))));
                        b.finalLore(InventoryMenu.lore(Objects.requireNonNull(section.getList("lore", new ArrayList()))));
                        b.operation(InventoryMenu.callbacks(section));
                    });
                }
            }
            this.logger.info("loaded page configuration {} ({})", (Object)id, (Object)file);
        }
        catch (Exception e) {
            this.logger.info("found error while loading page {}:", (Object)file);
            this.logger.catching((Throwable)e);
        }
    }

    public void loadComponents(ConfigurationSection sect, String file) {
        for (String s : sect.getKeys(false)) {
            this.components.put(s, new Component(Objects.requireNonNull(sect.getConfigurationSection(s))));
        }
        this.logger.info("component provider {}", (Object)file);
    }

    public void execute(CommandExecution context) {
        switch (context.requireEnum(0, new String[]{"open", "reload"})) {
            case "open": {
                this.menus.get(context.requireArgumentAt(1)).open(context.requireSenderAsPlayer());
                break;
            }
            case "load": {
                this.load();
            }
        }
    }

    public void suggest(CommandSuggestion suggestion) {
        suggestion.matchArgument(0, "open", ctx -> ctx.suggest(1, this.menus.keySet()));
        suggestion.suggest(0, new String[]{"open", "reload"});
    }

    public static final class MenuData {
        private final List<UIOpenCommand> commands = new ArrayList<UIOpenCommand>();
        private final InventoryUI ui;
        private final Permission permission;

        public MenuData(InventoryUI ui, Permission permission, List<String> commands) {
            this.ui = ui;
            this.permission = permission;
            try {
                for (String command : commands) {
                    this.commands.add(new UIOpenCommand(command.substring(1), this));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void open(Player player) {
            if (this.permission != null && !player.hasPermission(this.permission)) {
                Quark.getInstance().getCommandManager().sendPermissionMessage((CommandSender)player, this.permission.getName());
                return;
            }
            this.ui.createInventoryUI(player).open();
        }

        public void register() {
            for (UIOpenCommand command : this.commands) {
                Quark.getInstance().getCommandManager().register((AbstractCommand)command);
            }
        }

        public void destroy() {
            for (UIOpenCommand command : this.commands) {
                Quark.getInstance().getCommandManager().unregister((AbstractCommand)command);
            }
        }
    }

    public static final class Component {
        private final IconRenderer icon;
        private final TextRenderer name;
        private final LoreRenderer lore;
        private final ElementCallback callbacks;

        public Component(ConfigurationSection section) {
            this.icon = InventoryMenu.icon(Objects.requireNonNull(section.getConfigurationSection("icon")));
            this.name = InventoryMenu.text(Objects.requireNonNull(section.getConfigurationSection("name")));
            this.lore = InventoryMenu.lore(Objects.requireNonNull(section.getList("lore", new ArrayList())));
            this.callbacks = InventoryMenu.callbacks(section);
        }

        public void build(InventoryUI ui, int slot) {
            UI.buildComponent((InventoryUI)ui, (int)slot, b -> {
                b.icon(this.icon);
                b.name(this.name);
                b.finalLore(this.lore);
                b.operation(this.callbacks);
            });
        }
    }

    @QuarkCommand(name="__")
    public static final class UIOpenCommand
    extends AbstractCommand {
        private final String name;
        private final MenuData ref;

        public UIOpenCommand(String name, MenuData ref) {
            this.name = name;
            this.ref = ref;
        }

        public void execute(CommandExecution context) {
            this.ref.open(context.requireSenderAsPlayer());
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

