/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.utilities;

import java.util.List;
import java.util.Objects;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecutor;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.LanguageItem;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.command.QuarkCommandExecutor;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.customcontent.CustomMeta;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="0.3")
@AutoRegister(value={"qb:el"})
@CommandProvider(value={ItemCommandCommand.class})
public final class ItemCommand
extends PackageModule
implements QuarkCommandExecutor {
    @Inject(value="tip")
    private LanguageItem tip;

    public void enable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tip));
    }

    public void disable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tip));
    }

    public void checkCompatibility() {
        Compatibility.requirePDC();
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player p = event.getPlayer();
        ItemStack hand = event.getItem();
        if (hand == null) {
            return;
        }
        if (!CustomMeta.hasItemPDCProperty((ItemStack)hand, (String)"cmd_bind")) {
            return;
        }
        String cmd = Objects.requireNonNull(CustomMeta.getItemPDCProperty((ItemStack)hand, (String)"cmd_bind"));
        event.setCancelled(true);
        if (cmd.contains("dm open")) {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmd + " " + event.getPlayer().getName());
            return;
        }
        Bukkit.getServer().dispatchCommand((CommandSender)p, cmd);
    }

    public void onCommand(CommandSender sender, String[] args) {
        ItemStack stack = ((Player)sender).getInventory().getItemInMainHand();
        if (stack.getType() == Material.AIR) {
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"bind-failed", (Object[])new Object[0]);
            return;
        }
        String id = stack.getType().getKey().getKey();
        if (args[0].equals("none")) {
            CustomMeta.removeItemPDCProperty((ItemStack)stack, (String)"cmd_bind");
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"unbind", (Object[])new Object[]{id});
        } else {
            StringBuilder sb = new StringBuilder();
            for (String s : args) {
                sb.append(s).append(" ");
            }
            String cmdLine = sb.toString();
            CustomMeta.setItemPDCProperty((ItemStack)stack, (String)"cmd_bind", (String)cmdLine);
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"bind", (Object[])new Object[]{id, cmdLine});
        }
    }

    public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
        if (buffer.length == 1) {
            tabList.add("none");
            tabList.add("<command line>");
        }
    }

    @QuarkCommand(name="item-command", playerOnly=true)
    public static final class ItemCommandCommand
    extends ModuleCommand<ItemCommand> {
        public void init(ItemCommand module) {
            this.setExecutor((CommandExecutor)module);
        }
    }
}

