/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.utilities;

import java.util.List;
import me.gb2022.commons.reflect.AutoRegister;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.customcontent.CustomMeta;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="0.3")
@AutoRegister(value={"qb:el"})
@CommandProvider(value={ItemCommandCommand.class})
public final class ItemCustomName
extends PackageModule {
    public void checkCompatibility() {
        Compatibility.requirePDC();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.refreshInventory((Inventory)event.getPlayer().getInventory(), LocaleService.locale((CommandSender)event.getPlayer()));
    }

    @EventHandler
    public void onHarvest(PlayerHarvestBlockEvent event) {
        for (ItemStack itemStack : event.getItemsHarvested()) {
            this.refreshItem(itemStack, LocaleService.locale((CommandSender)event.getPlayer()));
        }
    }

    @EventHandler
    public void onInvClick(InventoryClickEvent event) {
        if (event.getClickedInventory() == null) {
            return;
        }
        this.refreshInventory(event.getClickedInventory(), LocaleService.locale((CommandSender)event.getWhoClicked()));
    }

    private void refreshInventory(Inventory inv, MinecraftLocale locale) {
        for (ItemStack stack : inv.getContents()) {
            if (stack == null || stack.getItemMeta() == null) continue;
            this.refreshItem(stack, locale);
        }
    }

    private void refreshItem(ItemStack stack, MinecraftLocale locale) {
        ItemMeta meta = stack.getItemMeta();
        if (!CustomMeta.hasItemPDCProperty((ItemStack)stack, (String)"custom_name")) {
            return;
        }
        String key = CustomMeta.getItemPDCProperty((ItemStack)stack, (String)"custom_name");
        meta.displayName(this.getLanguage().item(key).component(locale, new Object[0]).asComponent());
        stack.setItemMeta(meta);
    }

    @QuarkCommand(name="item-custom-name", playerOnly=true)
    public static final class ItemCommandCommand
    extends ModuleCommand<ItemCustomName> {
        public void onCommand(CommandSender sender, String[] args) {
            ItemStack stack = ((Player)sender).getInventory().getItemInMainHand();
            if (stack.getType() == Material.AIR) {
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"bind-failed", (Object[])new Object[0]);
                return;
            }
            String id = stack.getType().getKey().getKey();
            if (args[0].equals("none")) {
                CustomMeta.removeItemPDCProperty((ItemStack)stack, (String)"custom_name");
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"unbind", (Object[])new Object[]{id});
            } else {
                StringBuilder sb = new StringBuilder();
                for (String s : args) {
                    sb.append(s).append(" ");
                }
                String cmdLine = sb.substring(0, sb.length() - 1);
                CustomMeta.setItemPDCProperty((ItemStack)stack, (String)"custom_name", (String)cmdLine);
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"bind", (Object[])new Object[]{id, cmdLine});
            }
            ((ItemCustomName)this.getModule()).refreshItem(stack, LocaleService.locale((CommandSender)sender));
        }

        public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
            if (buffer.length == 1) {
                tabList.add("none");
                tabList.add("<name>");
            }
        }
    }
}

