/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.utilities;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.gb2022.apm.local.ListedBroadcastEvent;
import me.gb2022.apm.local.PluginMessageHandler;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.rewrite.RewriteAppender;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderControlArraySet;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFormatMessage;
import org.apache.logging.log4j.util.StringMap;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.GameTestService;

@QuarkModule
@AutoRegister(value={"qb:pm"})
public final class LogColorPatch
extends PackageModule {
    private final Map<String, Log4jConfiguration> configurations = new HashMap<String, Log4jConfiguration>();
    private final Set<String> injections = new HashSet<String>();
    @Inject
    public Logger logger;

    private Configuration config() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        return ctx.getConfiguration();
    }

    public void active(Appender appender) {
        appender.initialize();
        appender.start();
    }

    @PluginMessageHandler(value="quark:log:reconfigure")
    public void onMessageFetch(ListedBroadcastEvent event) {
        this.disable();
        this.enable();
    }

    private void reloadAppenders() {
        this.config().getAppenders().forEach((n, a) -> {
            if (a instanceof AbstractOutputStreamAppender) {
                return;
            }
            if (a.isStarted()) {
                a.stop();
            }
            a.initialize();
            a.start();
        });
    }

    public void disable() {
        for (String id : this.injections) {
            for (Log4jConfiguration config : this.configurations.values()) {
                this.uninject(config, id);
            }
        }
        this.injections.clear();
        this.configurations.clear();
        this.reloadAppenders();
        GameTestService.unregister((String)"log-color");
    }

    public void enable() {
        GameTestService.register((String)"log-color", () -> {
            for (String conf : this.configurations.keySet()) {
                this.test(conf, this.configurations.get(conf));
            }
        });
        Configuration config = this.config();
        this.configurations.clear();
        this.configurations.put("_root", Log4jConfiguration.root(config));
        this.configurations.put("root-logger", Log4jConfiguration.logger(config.getRootLogger()));
        for (LoggerConfig lc : this.config().getLoggers().values()) {
            this.configurations.put("logger-config:" + lc.getName(), Log4jConfiguration.logger(lc));
        }
        this.redirect("TerminalConsole", new ColorCharRewritePolicy.AnsiColorPolicy());
        this.redirect("File", new ColorCharRewritePolicy());
        this.redirect("ServerGuiConsole", new ColorCharRewritePolicy());
        this.reloadAppenders();
    }

    public void redirect(String id, RewritePolicy policy) {
        this.injections.add(id);
        for (Log4jConfiguration config : this.configurations.values()) {
            this.inject(config, id, policy);
        }
    }

    private void test(String lid, Log4jConfiguration config) {
        for (String logger : config.getAppenders().keySet()) {
            Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).setMessage((Message)new MessageFormatMessage("[%s:%s] \u00a73Test".formatted(lid, logger), new Object[0])).setLoggerName("_Test_").build();
            config.getAppenders().get(logger).append((LogEvent)event);
        }
    }

    private void inject(Log4jConfiguration config, String id, RewritePolicy policy) {
        String rid = id + "_rewrite_backend";
        Appender appender = config.getAppender(id);
        if (appender == null) {
            return;
        }
        if (config.getAppenders().containsKey(rid)) {
            return;
        }
        config.addAppender(rid, appender);
        this.active(appender);
        RewriteAppender rewrite = RewriteAppender.createAppender((String)id, (String)Boolean.toString(appender.ignoreExceptions()), (AppenderRef[])new AppenderRef[]{AppenderRef.createAppenderRef((String)rid, (Level)Level.INFO, null)}, (Configuration)this.config(), (RewritePolicy)policy, null);
        config.removeAppender(id);
        config.addAppender(id, (Appender)rewrite);
        this.active((Appender)rewrite);
    }

    private void uninject(Log4jConfiguration config, String id) {
        String rid = id + "_rewrite_backend";
        Appender appender = config.getAppender(rid);
        if (appender == null) {
            return;
        }
        config.removeAppender(id);
        config.removeAppender(rid);
        config.addAppender(id, appender);
        this.active(appender);
    }

    static interface Log4jConfiguration {
        public static Log4jConfiguration root(final Configuration config) {
            return new Log4jConfiguration(){

                @Override
                public Map<String, Appender> getAppenders() {
                    return config.getAppenders();
                }

                @Override
                public void removeAppender(String id) {
                    config.getAppenders().remove(id);
                }

                @Override
                public void addAppender(String id, Appender appender) {
                    config.getAppenders().put(id, appender);
                }
            };
        }

        public static Log4jConfiguration logger(LoggerConfig config) {
            return new LoggerConfigWrapper(config);
        }

        public void addAppender(String var1, Appender var2);

        public void removeAppender(String var1);

        public Map<String, Appender> getAppenders();

        default public Appender getAppender(String id) {
            return this.getAppenders().get(id);
        }

        public static class LoggerConfigWrapper
        implements Log4jConfiguration {
            private final AppenderControlArraySet controlSet;

            public LoggerConfigWrapper(LoggerConfig config) {
                try {
                    Field f_controlSet = LoggerConfig.class.getDeclaredField("appenders");
                    f_controlSet.setAccessible(true);
                    this.controlSet = (AppenderControlArraySet)f_controlSet.get(config);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Map<String, Appender> getAppenders() {
                return this.controlSet.asMap();
            }

            @Override
            public void removeAppender(String id) {
                this.controlSet.remove(id);
            }

            @Override
            public void addAppender(String id, Appender appender) {
                this.controlSet.add(this.redirectNamed(appender, id));
            }

            private AppenderControl redirectNamed(Appender appender, String name) {
                try {
                    AppenderControl control = new AppenderControl(appender, Level.INFO, null);
                    Field f_control = AppenderControl.class.getDeclaredField("appenderName");
                    f_control.setAccessible(true);
                    f_control.set(control, name);
                    return control;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class ColorCharRewritePolicy
    implements RewritePolicy {
        private ColorCharRewritePolicy() {
        }

        public LogEvent rewrite(LogEvent source) {
            Message message = source.getMessage();
            if (message == null) {
                return source;
            }
            String newMessage = this.replace(message.getFormattedMessage());
            return Log4jLogEvent.newBuilder().setLoggerName(source.getLoggerName()).setLoggerFqcn(source.getLoggerFqcn()).setLevel(source.getLevel()).setMessage((Message)new MessageFormatMessage(newMessage, new Object[0])).setThrown(source.getThrown()).setContextData((StringMap)source.getContextData()).setContextStack(source.getContextStack()).setThreadName(source.getThreadName()).setTimeMillis(source.getTimeMillis()).setSource(source.getSource()).build();
        }

        protected String replace(String origin) {
            return origin.replaceAll("\u00a7[a-z]", "").replaceAll("\u00a7[0-9]", "");
        }

        private static final class AnsiColorPolicy
        extends ColorCharRewritePolicy {
            private AnsiColorPolicy() {
            }

            @Override
            public String replace(String origin) {
                return super.replace(origin.replace("\u00a70", "\u001b[30m").replace("\u00a71", "\u001c[34m").replace("\u00a72", "\u001b[32m").replace("\u00a73", "\u001b[36m").replace("\u00a74", "\u001b[31m").replace("\u00a75", "\u001b[35m").replace("\u00a76", "\u001b[33m").replace("\u00a77", "\u001b[37m").replace("\u00a78", "\u001b[90m").replace("\u00a79", "\u001b[94m").replace("\u00a7a", "\u001b[92m").replace("\u00a7b", "\u001b[96m").replace("\u00a7c", "\u001b[91m").replace("\u00a7d", "\u001b[95m").replace("\u00a7e", "\u001b[93m").replace("\u00a7f", "\u001b[39m").replace("\u00a7r", "\u001b[39m"));
            }
        }
    }
}

