/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.utilities;

import java.util.HashSet;
import java.util.List;
import me.gb2022.commons.reflect.AutoRegister;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.MessageAccessor;
import org.tbstcraft.quark.util.CachedInfo;

@AutoRegister(value={"qb:el"})
@QuarkModule(version="1.0.0")
@CommandProvider(value={LockPositionCommand.class})
public final class PlayerPositionLock
extends PackageModule {
    private final HashSet<String> lockedPlayers = new HashSet();

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.lockedPlayers.contains(event.getPlayer().getName())) {
            event.setCancelled(true);
        }
    }

    private boolean isLocked(String name) {
        return this.lockedPlayers.contains(name);
    }

    private void toggle(String name) {
        Player p = Bukkit.getPlayerExact((String)name);
        if (p == null) {
            return;
        }
        if (this.isLocked(name)) {
            this.lockedPlayers.remove(name);
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)p, (String)"unlock", (Object[])new Object[0]);
        } else {
            this.lockedPlayers.add(name);
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)p, (String)"lock", (Object[])new Object[0]);
        }
    }

    @QuarkCommand(name="lock-position", permission="+quark.lock")
    public static final class LockPositionCommand
    extends ModuleCommand<PlayerPositionLock> {
        public void onCommand(CommandSender sender, String[] args) {
            if (args.length > 0) {
                if (!sender.isOp()) {
                    this.sendPermissionMessage(sender, "(ServerOperator)");
                    return;
                }
                ((PlayerPositionLock)this.getModule()).toggle(args[0]);
                if (((PlayerPositionLock)this.getModule()).isLocked(args[0])) {
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"lock-player", (Object[])new Object[]{args[0]});
                } else {
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"unlock-player", (Object[])new Object[]{args[0]});
                }
                return;
            }
            if (sender instanceof ConsoleCommandSender) {
                this.sendPlayerOnlyMessage(sender);
            }
            ((PlayerPositionLock)this.getModule()).toggle(sender.getName());
        }

        public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
            tabList.addAll(CachedInfo.getOnlinePlayerNames());
        }
    }
}

