/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.utilities;

import java.util.List;
import me.gb2022.apm.local.MappedBroadcastEvent;
import me.gb2022.apm.local.PluginMessageHandler;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.LanguageItem;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.foundation.platform.Players;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule
@QuarkCommand(name="refresh-area", permission="-quark.refresh.command", playerOnly=true)
@AutoRegister(value={"qb:pm"})
public final class SurroundingRefresh
extends CommandModule {
    @Inject
    private LanguageEntry language;
    @Inject(value="tip")
    private LanguageItem tip;

    public void enable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tip));
        super.enable();
    }

    public void disable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tip));
        super.disable();
    }

    public void onCommand(CommandSender sender, String[] args) {
        Player target;
        int rad = Integer.parseInt(args[0]);
        if (rad > 9) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"to-big", (Object[])new Object[]{rad});
            return;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            target = player;
        } else {
            if (!sender.isOp()) {
                this.sendPermissionMessage(sender);
                return;
            }
            target = Bukkit.getPlayerExact((String)args[1]);
            if (target == null) {
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"not-found", (Object[])new Object[0]);
                return;
            }
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"success", (Object[])new Object[]{rad});
        }
        this.refreshArea(target, rad, false);
    }

    public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
        if (buffer.length == 1) {
            tabList.add("3");
            tabList.add("5");
            tabList.add("7");
            tabList.add("9");
        }
        if (buffer.length == 2) {
            if (!sender.isOp()) {
                return;
            }
            tabList.addAll(Players.getAllOnlinePlayerNames());
        }
    }

    @PluginMessageHandler(value="quark:explosion")
    public void onPluginMessage(MappedBroadcastEvent event) {
        Location loc = (Location)event.getProperty("loc", Location.class);
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.getWorld() != loc.getWorld() || !(loc.distance(p.getLocation()) < 64.0)) continue;
            this.refreshArea(p, 7, true);
        }
    }

    public void refreshArea(Player p, int radius, boolean silent) {
        int x = p.getLocation().getBlockX();
        int y = p.getLocation().getBlockY();
        int z = p.getLocation().getBlockZ();
        if (!silent) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)p, (String)"refresh-target", (Object[])new Object[]{radius});
        }
        int delay = 0;
        for (int xx = x - radius; xx <= x + radius; ++xx) {
            for (int yy = y - radius; yy <= y + radius; ++yy) {
                for (int zz = z - radius; zz <= z + radius; ++zz) {
                    Location loc = new Location(p.getWorld(), (double)xx, (double)yy, (double)zz);
                    if (!silent) {
                        TaskService.global().delay((long)delay, () -> p.sendBlockChange(loc, Material.AIR.createBlockData()));
                        TaskService.global().delay((long)(delay + 5), () -> p.sendBlockChange(loc, loc.getBlock().getBlockData()));
                        continue;
                    }
                    p.sendBlockChange(loc, Material.AIR.createBlockData());
                    p.sendBlockChange(loc, loc.getBlock().getBlockData());
                }
            }
            ++delay;
        }
        if (!silent) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)p, (String)"refresh-complete", (Object[])new Object[0]);
        }
    }
}

