/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.utilities;

import java.util.List;
import java.util.Objects;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.assertion.NumberLimitation;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.0")
@QuarkCommand(name="server-tick", permission="-quark.tick")
public final class TickManager
extends CommandModule {
    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requireClass(() -> Class.forName("org.bukkit.ServerTickManager"));
    }

    public void execute(CommandExecution execution) {
        switch (execution.requireEnum(0, new String[]{"freeze", "unfreeze", "step"})) {
            case "freeze": {
                Bukkit.getServer().getServerTickManager().setFrozen(true);
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)execution.getSender(), (String)"freeze", (Object[])new Object[0]);
                break;
            }
            case "unfreeze": {
                Bukkit.getServer().getServerTickManager().setFrozen(false);
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)execution.getSender(), (String)"unfreeze", (Object[])new Object[0]);
                break;
            }
            case "step": {
                int stp = execution.requireArgumentInteger(1, new NumberLimitation[]{NumberLimitation.any()});
                Bukkit.getServer().getServerTickManager().stepGameIfFrozen(stp);
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)execution.getSender(), (String)"step", (Object[])new Object[]{stp});
            }
        }
    }

    public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
        if (buffer.length == 1) {
            tabList.add("freeze");
            tabList.add("unfreeze");
            tabList.add("step");
        }
        if (buffer.length == 2 && Objects.equals(buffer[0], "step")) {
            tabList.addAll(List.of("1", "2", "3", "4", "5", "6", "7", "8", "9", "10"));
        }
    }
}

