/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.utilities.viewdistance;

import me.gb2022.commons.math.MathHelper;
import org.atcraftmc.quark.utilities.viewdistance.ViewDistanceStrategy;
import org.bukkit.entity.Player;
import org.tbstcraft.quark.data.storage.access.PlayerDataAccess;

public final class CustomSettingStrategy
implements ViewDistanceStrategy {
    public static final PlayerDataAccess<Byte> STORAGE_ACCESS = PlayerDataAccess.byteElement((String)"view_distance_custom");

    public static boolean has(Player player) {
        return CustomSettingStrategy.get(player) != -1;
    }

    public static int set(Player player, int value) {
        value = (int)MathHelper.clamp((double)value, (double)2.0, (double)32.0);
        STORAGE_ACCESS.setAndSave((Object)player, (Object)((byte)value));
        return value;
    }

    public static void clear(Player player) {
        CustomSettingStrategy.set(player, -1);
    }

    public static int get(Player player) {
        if (!STORAGE_ACCESS.contains((Object)player)) {
            return -1;
        }
        return ((Byte)STORAGE_ACCESS.get((Object)player)).byteValue();
    }

    @Override
    public int determine(Player player, int currentValue) {
        if (CustomSettingStrategy.has(player)) {
            return CustomSettingStrategy.get(player);
        }
        return currentValue;
    }

    @Override
    public boolean remindPlayer(Player player, boolean originalRemind) {
        return true;
    }
}

