/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.contents;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.gb2022.commons.reflect.Inject;
import org.apache.logging.log4j.Logger;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Recipe;
import org.tbstcraft.quark.data.assets.AssetGroup;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.crafting.RecipeDeserializer;
import org.tbstcraft.quark.foundation.crafting.RecipeManager;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.2.6")
@CommandProvider(value={RecipeCommand.class})
public final class CustomRecipe
extends PackageModule {
    private final Set<Recipe> recipes = new HashSet<Recipe>();
    @Inject(value="recipe;false")
    private AssetGroup recipeFiles;
    @Inject
    private Logger logger;

    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requireClass(() -> Class.forName("org.bukkit.inventory.RecipeChoice"));
    }

    public void load() {
        this.clear();
        for (String s : this.recipeFiles.list()) {
            this.logger.info("loading recipe bundle %s".formatted(s));
            ConfigurationSection map = YamlConfiguration.loadConfiguration((File)this.recipeFiles.getFile(s)).getConfigurationSection("recipes");
            if (map == null) continue;
            for (String id : map.getKeys(false)) {
                ConfigurationSection recipe = Objects.requireNonNull(map.getConfigurationSection(id));
                if (recipe.contains("repeat")) {
                    this.recipes.addAll(RecipeDeserializer.deserializeRepeatable((String)id, (ConfigurationSection)recipe));
                    continue;
                }
                Recipe r = RecipeDeserializer.deserialize((String)id, (ConfigurationSection)recipe);
                this.recipes.add(r);
            }
            RecipeManager.register((Recipe[])this.recipes.toArray(new Recipe[0]));
        }
    }

    public void clear() {
        RecipeManager.unregister((Recipe[])this.recipes.toArray(new Recipe[0]));
        this.recipes.clear();
    }

    public void restoreDefault() {
        this.recipeFiles.save("vanilla-fixes.yml");
        this.recipeFiles.save("wood-cuttings.yml");
    }

    public void enable() {
        if (!this.recipeFiles.existFolder()) {
            this.restoreDefault();
        }
        this.load();
    }

    public void disable() {
        this.clear();
    }

    @QuarkCommand(name="recipes", permission="-quark.recipe")
    public static final class RecipeCommand
    extends ModuleCommand<CustomRecipe> {
        public void onCommand(CommandSender sender, String[] args) {
            switch (args[0]) {
                case "reload": {
                    ((CustomRecipe)this.getModule()).load();
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"reload", (Object[])new Object[0]);
                    break;
                }
                case "restore": {
                    ((CustomRecipe)this.getModule()).restoreDefault();
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"restore", (Object[])new Object[0]);
                }
            }
        }

        public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
            if (buffer.length == 1) {
                tabList.add("reload");
                tabList.add("restore");
            }
        }
    }
}

