/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.contents;

import java.util.Objects;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import net.kyori.adventure.text.ComponentLike;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.language.LanguageItem;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.tbstcraft.quark.Quark;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.crafting.PatternSymbol;
import org.tbstcraft.quark.foundation.crafting.RecipeBuilder;
import org.tbstcraft.quark.foundation.crafting.RecipeManager;
import org.tbstcraft.quark.foundation.platform.BukkitUtil;
import org.tbstcraft.quark.foundation.platform.Players;
import org.tbstcraft.quark.framework.customcontent.CustomMeta;
import org.tbstcraft.quark.framework.customcontent.item.CustomItem;
import org.tbstcraft.quark.framework.customcontent.item.QuarkItem;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;

@AutoRegister(value={"qb:el"})
@CommandProvider(value={ElevatorItemCommand.class})
@QuarkModule(version="1.0.0")
public final class Elevator
extends PackageModule {
    public static final Recipe RECIPE = RecipeBuilder.shaped((String)"elevator", (String)"@#@;#*#;@#@", (ItemStack)Elevator.createElevatorItem(1), (PatternSymbol[])new PatternSymbol[]{RecipeBuilder.symbol((char)'#', (Material)Material.IRON_INGOT), RecipeBuilder.symbol((char)'*', (Material)Material.PISTON), RecipeBuilder.symbol((char)'@', (Material)Material.REDSTONE)});
    @Inject(value="tip")
    private LanguageItem tip;

    public static ItemStack createElevatorItem(int amount) {
        ItemStack stack = new ItemStack(Material.FURNACE, amount);
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return null;
        }
        meta.addEnchant(Enchantment.DURABILITY, 6, true);
        meta.setDisplayName("\u7535\u68af");
        stack.setItemMeta(meta);
        CustomMeta.setItemIdentifier((ItemStack)stack, (String)"elevator");
        return stack;
    }

    public void enable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tip));
        RecipeManager.register((Recipe[])new Recipe[]{RECIPE});
    }

    public void disable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tip));
        RecipeManager.unregister((Recipe[])new Recipe[]{RECIPE});
    }

    @EventHandler
    public void onPlayerJump(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Location to = event.getTo();
        Location from = event.getFrom();
        World world = from.getWorld();
        if (world == null) {
            return;
        }
        if (!BukkitUtil.testJump((Location)to, (Location)from)) {
            return;
        }
        Block b = BukkitUtil.getSteppingBlock((Location)from);
        if (b == null) {
            return;
        }
        if (!this.isValidElevator(b)) {
            return;
        }
        int x = from.getBlockX();
        int z = from.getBlockZ();
        double yo = player.getLocation().getY();
        for (int y = from.getBlockY() + 1; y < world.getMaxHeight(); ++y) {
            if (!this.isValidElevator(world.getBlockAt(x, y, z))) continue;
            Players.teleport((Entity)player, (Location)player.getLocation().add(0.0, (double)(y + 1) - yo, 0.0));
            player.playSound(player.getLocation(), Sound.BLOCK_PISTON_EXTEND, 1.0f, 0.0f);
            return;
        }
    }

    @EventHandler
    public void onPlayerShift(PlayerToggleSneakEvent event) {
        if (!event.isSneaking()) {
            return;
        }
        Player player = event.getPlayer();
        Location from = player.getLocation();
        World world = player.getWorld();
        Block b = BukkitUtil.getSteppingBlock((Location)from);
        if (b == null) {
            return;
        }
        if (!this.isValidElevator(b)) {
            return;
        }
        int x = from.getBlockX();
        int z = from.getBlockZ();
        double yo = player.getLocation().getY();
        for (int y = from.getBlockY() - 2; y > -65; --y) {
            if (!this.isValidElevator(world.getBlockAt(x, y, z))) continue;
            Players.teleport((Entity)player, (Location)player.getLocation().add(0.0, (double)(y + 1) - yo, 0.0));
            player.playSound(player.getLocation(), Sound.BLOCK_PISTON_CONTRACT, 1.0f, 0.0f);
            return;
        }
    }

    public boolean isValidElevator(Block b) {
        if (b.getType() != Material.FURNACE) {
            return false;
        }
        Furnace furnace = (Furnace)b.getState();
        if (!CustomMeta.matchPDCIdentifier((PersistentDataHolder)furnace, (String)"elevator")) {
            return false;
        }
        Block b1 = b.getWorld().getBlockAt(b.getLocation().add(0.0, 1.0, 0.0));
        Block b2 = b.getWorld().getBlockAt(b.getLocation().add(0.0, 2.0, 0.0));
        return b1.getType().isAir() && b2.getType().isAir();
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.getItemInHand().getType() != Material.FURNACE) {
            return;
        }
        if (!CustomMeta.matchItemIdentifier((ItemStack)event.getItemInHand(), (String)"elevator")) {
            return;
        }
        Furnace furnace = (Furnace)event.getBlock().getState();
        CustomMeta.setPDCIdentifier((PersistentDataHolder)furnace, (String)"elevator");
        furnace.update();
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (!this.isValidElevator(event.getBlock())) {
            return;
        }
        event.setDropItems(false);
        BukkitUtil.createDrop((Location)block.getLocation(), (ItemStack)Elevator.createElevatorItem(1));
    }

    @QuarkItem(id="quark:elevator", icon=Material.FURNACE, enchantGlow=true)
    public static final class ElevatorItem
    extends CustomItem {
        public ComponentLike renderDisplayName(ItemStack stack, MinecraftLocale locale) {
            return this.getLanguageKey().component(locale, new Object[0]);
        }

        public LanguageItem getLanguageKey() {
            return new LanguageItem(Quark.lang(), "quark-contents:elevator:item-name");
        }
    }

    @QuarkCommand(name="elevator", op=true, playerOnly=true)
    public static final class ElevatorItemCommand
    extends ModuleCommand<Elevator> {
        public void onCommand(CommandSender sender, String[] args) {
            ((Player)sender).getInventory().addItem(new ItemStack[]{Objects.requireNonNull(Elevator.createElevatorItem(64))});
        }
    }
}

