/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.contents;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import me.gb2022.commons.container.MultiMap;
import me.gb2022.commons.math.MathHelper;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import me.gb2022.commons.reflect.method.MethodHandle;
import me.gb2022.commons.reflect.method.MethodHandleO2;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.Language;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rail;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.util.Vector;
import org.tbstcraft.quark.PlayerView;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.foundation.TextSender;
import org.tbstcraft.quark.foundation.platform.BukkitUtil;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.framework.module.component.Components;
import org.tbstcraft.quark.framework.module.component.ModuleComponent;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@AutoRegister(value={"qb:el"})
@QuarkModule
@Components(value={PlayerWorldCache.class})
public final class RealisticMinecart
extends PackageModule {
    private static final String GLOBAL_TASK_ID = "quark:minecart:simulate";
    private static final double MAX_SAFE_SPEED = 0.6;
    private static final double SIMULATED_GRAVITY = 0.05;
    private static final MethodHandleO2<Entity, Float, Float> SET_ROTATION = (MethodHandleO2)MethodHandle.select(ctx -> {
        ctx.attempt(() -> Entity.class.getMethod("setRotation", Float.TYPE, Float.TYPE), (e, y, p) -> {
            try {
                e.setRotation(y.floatValue(), p.floatValue());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        });
        ctx.dummy((e, y, p) -> {});
    });
    @Inject
    private LanguageEntry language;

    public void enable() {
        TaskService.global().timer(GLOBAL_TASK_ID, 1L, 1L, this::tick);
        for (Player player : Bukkit.getOnlinePlayers()) {
            Entity entity;
            if (player.getVehicle() == null || !((entity = player.getVehicle()) instanceof Minecart)) continue;
            Minecart m = (Minecart)entity;
            this.initUI(m, player);
        }
    }

    public void disable() {
        TaskService.async().cancel(GLOBAL_TASK_ID);
    }

    @EventHandler
    public void onEnterMinecart(VehicleEnterEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof Minecart)) {
            return;
        }
        Minecart m = (Minecart)vehicle;
        Entity entity = event.getEntered();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        TaskService.entity((Entity)event.getEntered()).delay(1L, () -> {
            VirtualMinecartAgent agent = VirtualMinecartAgent.get(this, p);
            if (this.playerWorldCache().isPlayerWarped(p)) {
                agent.bind(m);
                m.setVelocity(new Vector(0, 0, 0));
                m.setVelocity(this.buildInitialSpeedVector(p));
            } else {
                VirtualMinecartAgent.AGENTS.remove((Object)p.getUniqueId());
                agent = VirtualMinecartAgent.get(this, p);
                p.getInventory().setHeldItemSlot(4);
                agent.setExpectedMaxSpeed(0.0);
                agent.setSpeedLimit(0.0);
            }
            this.playerWorldCache().updatePlayerWorld(p);
            this.initUI(m, p);
        });
    }

    @EventHandler
    public void onExitMinecart(VehicleExitEvent event) {
        if (!(event.getVehicle() instanceof Minecart)) {
            return;
        }
        LivingEntity livingEntity = event.getExited();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player p = (Player)livingEntity;
        PlayerView.ChannelRenderer view = PlayerView.getInstance((Player)p).getActionbar();
        view.removeChannel("quark:realistic-minecart:ui");
        this.playerWorldCache().updatePlayerWorld(p);
    }

    @EventHandler
    public void onSlotChange(PlayerItemHeldEvent event) {
        if (!(event.getPlayer().getVehicle() instanceof Minecart)) {
            return;
        }
        if (event.getPreviousSlot() == 0 && event.getNewSlot() == 8) {
            event.setCancelled(true);
        }
        if (event.getPreviousSlot() == 8 && event.getNewSlot() == 0) {
            event.setCancelled(true);
        }
    }

    private void initUI(Minecart m, Player p) {
        PlayerView.ChannelRenderer view = PlayerView.getInstance((Player)p).getActionbar();
        view.addChannel("quark:realistic-minecart:ui", 999, 2, (a, t) -> {
            int thrustLevel = p.getInventory().getHeldItemSlot() - 4;
            float acceleration = ConfigAccessor.getFloat((ConfigEntry)this.getConfig(), (String)("thrust-" + thrustLevel + "-acceleration"));
            double speed = m.getMaxSpeed();
            this.renderUI(p, speed, acceleration, thrustLevel);
        });
    }

    private void renderUI(Player p, double speed, double acceleration, int thrustLevel) {
        DecimalFormat fmt = SharedObjects.NUMBER_FORMAT;
        MinecraftLocale locale = LocaleService.locale((CommandSender)p);
        String template = Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"ui", (Function[])new Function[0]);
        String accelerationColumn = String.valueOf(fmt.format(acceleration * 20.0));
        String speedColumn = "%sm/s(%skm/h)".formatted(fmt.format(speed * 20.0), fmt.format(speed * 72.0));
        String thrustLevelColumn = String.valueOf(thrustLevel);
        String runMode = "";
        runMode = thrustLevel > 0 ? MessageAccessor.getMessage((LanguageEntry)this.language, (MinecraftLocale)locale, (String)"run-mode-boost", (Object[])new Object[0]) : (thrustLevel == 0 ? MessageAccessor.getMessage((LanguageEntry)this.language, (MinecraftLocale)locale, (String)"run-mode-run", (Object[])new Object[0]) : MessageAccessor.getMessage((LanguageEntry)this.language, (MinecraftLocale)locale, (String)"run-mode-break", (Object[])new Object[0]));
        if (speed == 0.0) {
            runMode = MessageAccessor.getMessage((LanguageEntry)this.language, (MinecraftLocale)locale, (String)"run-mode-stop", (Object[])new Object[0]);
        }
        if (speed == (double)ConfigAccessor.getFloat((ConfigEntry)this.getConfig(), (String)"max-speed")) {
            runMode = MessageAccessor.getMessage((LanguageEntry)this.language, (MinecraftLocale)locale, (String)"run-mode-run", (Object[])new Object[0]);
        }
        template = template.replace("{run-mode}", runMode);
        template = template.replace("{speed}", speedColumn).replace("{acceleration}", accelerationColumn).replace("{level}", thrustLevelColumn);
        String message = MessageAccessor.buildTemplate((LanguageEntry)this.language, (MinecraftLocale)locale, (String)template);
        TextSender.sendActionbarTitle((Player)p, (ComponentLike)TextBuilder.build((String)message, (Component[])new Component[0]));
    }

    private void tick() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.tickPlayerAndMinecart(p);
        }
    }

    private void tickPlayerAndMinecart(Player p) {
        Entity entity = p.getVehicle();
        if (!(entity instanceof Minecart)) {
            return;
        }
        Minecart minecart = (Minecart)entity;
        TaskService.entity((Entity)minecart).run(() -> {
            VirtualMinecartAgent agent = VirtualMinecartAgent.get(this, p);
            agent.tick();
            int thrustLevel = p.getInventory().getHeldItemSlot() - 4;
            float acceleration = ConfigAccessor.getFloat((ConfigEntry)this.getConfig(), (String)("thrust-" + thrustLevel + "-acceleration"));
            agent.setSpeedLimit(ConfigAccessor.getFloat((ConfigEntry)this.getConfig(), (String)"max-speed"));
            agent.setAcceleration(acceleration / 20.0f);
            if (agent.expectedMaxSpeed == 0.0 && thrustLevel <= 0) {
                minecart.setVelocity(new Vector(0, 0, 0));
            }
            if (BukkitUtil.getMaximumAxis((Vector)minecart.getVelocity()) == 0.0 && thrustLevel > 0) {
                minecart.setVelocity(this.buildInitialSpeedVector(p));
            }
        });
    }

    private PlayerWorldCache playerWorldCache() {
        return (PlayerWorldCache)this.getComponent(PlayerWorldCache.class);
    }

    private Vector buildInitialSpeedVector(Player p) {
        Vector rotation = p.getLocation().getDirection();
        Vector vector = new Vector(0, 0, 0);
        if (rotation.getZ() > 0.0) {
            vector.setZ(1);
        } else {
            vector.setZ(-1);
        }
        if (rotation.getX() > 0.0) {
            vector.setX(1);
        } else {
            vector.setX(-1);
        }
        return vector;
    }

    @AutoRegister(value={"qb:el"})
    public static class PlayerWorldCache
    extends ModuleComponent<RealisticMinecart> {
        private final Map<UUID, World> playerWorldTable = new HashMap<UUID, World>();

        public void enable() {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.updatePlayerWorld(player);
            }
        }

        public void disable() {
            this.playerWorldTable.clear();
        }

        @EventHandler
        public void onPlayerJoin(PlayerJoinEvent event) {
            this.updatePlayerWorld(event.getPlayer());
        }

        @EventHandler
        public void onPlayerRespawn(PlayerRespawnEvent event) {
            if (!(event.getPlayer().getVehicle() instanceof Minecart)) {
                this.updatePlayerWorld(event.getPlayer());
            }
        }

        public boolean isPlayerWarped(Player player) {
            if (!this.playerWorldTable.containsKey(player.getUniqueId())) {
                return false;
            }
            return player.getWorld() != this.playerWorldTable.get(player.getUniqueId());
        }

        public void updatePlayerWorld(Player player) {
            this.playerWorldTable.put(player.getUniqueId(), player.getWorld());
        }
    }

    public static final class VirtualMinecartAgent {
        public static final MultiMap<UUID, VirtualMinecartAgent> AGENTS = new MultiMap();
        private final RealisticMinecart holder;
        private Minecart minecart;
        private Location lastLocation;
        private boolean lastRailed;
        private Vector lastRecordedVelocity;
        private double expectedMaxSpeed;
        private double acceleration = 0.15f;
        private double speedLimit = 0.4f;
        private double lastYaw = 0.0;
        private double lastPitch = 0.0;

        public VirtualMinecartAgent(RealisticMinecart holder, Minecart minecart) {
            this.holder = holder;
            this.minecart = minecart;
            this.expectedMaxSpeed = minecart.getMaxSpeed();
        }

        static VirtualMinecartAgent get(RealisticMinecart holder, Player player) {
            return (VirtualMinecartAgent)AGENTS.computeIfAbsent((Object)player.getUniqueId(), m -> new VirtualMinecartAgent(holder, (Minecart)Objects.requireNonNull(player.getVehicle())));
        }

        private static boolean isRail(Material material) {
            return material == Material.RAIL || material == Material.ACTIVATOR_RAIL || material == Material.POWERED_RAIL || material == Material.DETECTOR_RAIL;
        }

        public void bind(Minecart minecart) {
            this.minecart = minecart;
        }

        public void tick() {
            boolean shouldSlow;
            this.expectedMaxSpeed = MathHelper.clamp((double)(this.expectedMaxSpeed + this.acceleration), (double)0.0, (double)this.speedLimit);
            Location loc = this.minecart.getLocation();
            if (this.lastLocation == null) {
                this.lastLocation = loc;
            }
            double dx = loc.getX() - this.lastLocation.getX();
            double dy = loc.getY() - this.lastLocation.getY();
            double dz = loc.getZ() - this.lastLocation.getZ();
            Block b1 = this.minecart.getLocation().subtract(0.0, 1.0, 0.0).getBlock();
            Block b2 = this.minecart.getLocation().getBlock();
            boolean railed = VirtualMinecartAgent.isRail(b1.getType()) || VirtualMinecartAgent.isRail(b2.getType());
            Vector velocity = new Vector(dx, dy, dz);
            if (velocity.length() > 0.0 && this.holder.getConfig().value("auto-align").bool()) {
                double yaw = Math.atan2(-velocity.getX(), velocity.getZ()) * 57.29577951308232;
                double pitch = Math.atan2(-velocity.getY(), Math.sqrt(velocity.getX() * velocity.getX() + velocity.getZ() * velocity.getZ())) * 57.29577951308232;
                if (this.lastYaw != yaw || this.lastPitch != pitch) {
                    for (Entity e : this.minecart.getPassengers()) {
                        SET_ROTATION.invoke((Object)e, (Object)Float.valueOf((float)yaw), (Object)Float.valueOf((float)pitch));
                    }
                    this.lastYaw = yaw;
                    this.lastPitch = pitch;
                }
            }
            if (this.minecart.isOnGround()) {
                return;
            }
            if (this.lastRailed && !railed) {
                this.lastRecordedVelocity = velocity.multiply(new Vector(1.0, 1.5, 1.0));
            }
            if (!railed) {
                if (this.lastRecordedVelocity == null) {
                    this.lastRecordedVelocity = velocity;
                }
                this.lastRecordedVelocity = this.lastRecordedVelocity.subtract(new Vector(0.0, 0.05, 0.0));
                this.minecart.setVelocity(this.lastRecordedVelocity);
            }
            this.minecart.setMaxSpeed((shouldSlow = this.shouldSlow()) ? Math.min(0.6, this.expectedMaxSpeed) : this.expectedMaxSpeed);
            this.lastLocation = loc;
            this.lastRailed = railed;
        }

        public boolean shouldSlow() {
            int r = (int)(10.0 * MathHelper.clamp((double)this.minecart.getMaxSpeed(), (double)0.4, (double)1.0));
            int x = this.minecart.getLocation().getBlockX();
            int y = this.minecart.getLocation().getBlockY();
            int z = this.minecart.getLocation().getBlockZ();
            for (int xx = x - r; xx <= x + r; ++xx) {
                for (int zz = z - r; zz <= z + r; ++zz) {
                    Rail rail;
                    Location loc = new Location(this.minecart.getWorld(), (double)xx, (double)y, (double)zz);
                    Block block = loc.getBlock();
                    if (block.getType() == Material.RAIL) {
                        return true;
                    }
                    BlockData data = block.getBlockData();
                    if (!VirtualMinecartAgent.isRail(block.getType()) || (rail = (Rail)data).getShape() != Rail.Shape.ASCENDING_NORTH && rail.getShape() != Rail.Shape.ASCENDING_SOUTH && rail.getShape() != Rail.Shape.ASCENDING_EAST && rail.getShape() != Rail.Shape.ASCENDING_WEST) continue;
                    return true;
                }
            }
            return false;
        }

        public void setAcceleration(double acceleration) {
            this.acceleration = acceleration;
        }

        public void setSpeedLimit(double speedLimit) {
            this.speedLimit = speedLimit;
        }

        public void setExpectedMaxSpeed(double expectedMaxSpeed) {
            this.expectedMaxSpeed = expectedMaxSpeed;
        }
    }
}

