/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.contents.music;

import java.util.Arrays;
import org.atcraftmc.quark.contents.music.EnumInstrument;

public interface InstrumentDecoder {
    public static InstrumentDecoder legacy() {
        return key -> EnumInstrument.PIANO;
    }

    public static InstrumentDecoder modern_gpt() {
        return type -> {
            if (type >= 0 && type <= 7) {
                return EnumInstrument.PIANO;
            }
            if (type == 118) {
                return EnumInstrument.SNARE_DRUM;
            }
            if (type == 115) {
                return EnumInstrument.STICKS;
            }
            if (type == 119) {
                return EnumInstrument.BASS_DRUM;
            }
            if (type == 73) {
                return EnumInstrument.FLUTE;
            }
            if (type == 113) {
                return EnumInstrument.BELL;
            }
            if (type == 112) {
                return EnumInstrument.CHIME;
            }
            if (type == 13) {
                return EnumInstrument.XYLOPHONE;
            }
            if (type == 95) {
                return EnumInstrument.IRON_XYLOPHONE;
            }
            if (type == 11) {
                return EnumInstrument.COW_BELL;
            }
            if (type == 12) {
                return EnumInstrument.DIDGERIDOO;
            }
            if (type == 8) {
                return EnumInstrument.BIT;
            }
            if (type == 105) {
                return EnumInstrument.BANJO;
            }
            if (type == 9) {
                return EnumInstrument.PLING;
            }
            if (type >= 8 && type <= 15) {
                return EnumInstrument.PIANO;
            }
            if (type >= 24 && type <= 31) {
                return EnumInstrument.GUITAR;
            }
            if (type >= 32 && type <= 39) {
                return EnumInstrument.BASS_GUITAR;
            }
            if (type >= 53 && type <= 81) {
                return EnumInstrument.COW_BELL;
            }
            return switch (type) {
                case 42, 44, 46 -> EnumInstrument.STICKS;
                case 41, 43, 45, 47, 48, 50 -> EnumInstrument.BASS_DRUM;
                case 49, 51, 52 -> EnumInstrument.STICKS;
                default -> EnumInstrument.UNKNOWN;
            };
        };
    }

    public static InstrumentDecoder modern() {
        return SimpleMidiTable::get;
    }

    public EnumInstrument dispatch(int var1);

    public static interface SimpleMidiTable {
        public static final EnumInstrument[] MAP = new EnumInstrument[128];

        private static void range(int start, int end, EnumInstrument instrument) {
            for (int i = start; i <= end; ++i) {
                SimpleMidiTable.MAP[i] = instrument;
            }
        }

        private static void item(int index, EnumInstrument instrument) {
            SimpleMidiTable.MAP[index] = instrument;
        }

        public static void init() {
            Arrays.fill((Object[])MAP, (Object)EnumInstrument.PIANO);
            SimpleMidiTable.range(0, 3, EnumInstrument.PIANO);
            SimpleMidiTable.range(4, 7, EnumInstrument.PLING);
            SimpleMidiTable.item(8, EnumInstrument.IRON_XYLOPHONE);
            SimpleMidiTable.item(9, EnumInstrument.CHIME);
            SimpleMidiTable.item(10, EnumInstrument.BELL);
            SimpleMidiTable.item(11, EnumInstrument.IRON_XYLOPHONE);
            SimpleMidiTable.item(12, EnumInstrument.XYLOPHONE);
            SimpleMidiTable.item(13, EnumInstrument.XYLOPHONE);
            SimpleMidiTable.item(14, EnumInstrument.CHIME);
            SimpleMidiTable.item(15, EnumInstrument.PIANO);
            SimpleMidiTable.range(16, 23, EnumInstrument.FLUTE);
            SimpleMidiTable.range(24, 31, EnumInstrument.GUITAR);
            SimpleMidiTable.item(26, EnumInstrument.PIANO);
            SimpleMidiTable.range(32, 35, EnumInstrument.BASS_GUITAR);
            SimpleMidiTable.range(36, 39, EnumInstrument.BASS_DRUM);
            SimpleMidiTable.range(40, 47, EnumInstrument.GUITAR);
            SimpleMidiTable.range(48, 51, EnumInstrument.GUITAR);
            SimpleMidiTable.range(52, 54, EnumInstrument.HUMAN_VOICE);
            SimpleMidiTable.item(55, EnumInstrument.PLING);
            SimpleMidiTable.range(56, 59, EnumInstrument.FLUTE);
            SimpleMidiTable.range(60, 63, EnumInstrument.DIDGERIDOO);
            SimpleMidiTable.range(64, 67, EnumInstrument.FLUTE);
            SimpleMidiTable.range(68, 71, EnumInstrument.DIDGERIDOO);
            SimpleMidiTable.range(72, 79, EnumInstrument.FLUTE);
            SimpleMidiTable.range(80, 81, EnumInstrument.BIT);
            SimpleMidiTable.range(82, 84, EnumInstrument.FLUTE);
            SimpleMidiTable.item(85, EnumInstrument.HUMAN_VOICE);
            SimpleMidiTable.range(86, 87, EnumInstrument.BASS_DRUM);
            SimpleMidiTable.item(96, EnumInstrument.SNARE_DRUM);
            SimpleMidiTable.item(102, EnumInstrument.BASS_GUITAR);
            SimpleMidiTable.item(112, EnumInstrument.BELL);
            SimpleMidiTable.item(113, EnumInstrument.CHIME);
            SimpleMidiTable.item(114, EnumInstrument.BASS_DRUM);
            SimpleMidiTable.item(115, EnumInstrument.XYLOPHONE);
            SimpleMidiTable.item(116, EnumInstrument.BASS_DRUM);
            SimpleMidiTable.item(117, EnumInstrument.BASS_DRUM);
            SimpleMidiTable.item(118, EnumInstrument.XYLOPHONE);
        }

        public static EnumInstrument get(int key) {
            if (MAP[0] == null) {
                SimpleMidiTable.init();
            }
            return MAP[key];
        }
    }
}

