/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.contents.music;

import java.util.ArrayList;
import java.util.List;
import org.atcraftmc.quark.contents.music.MusicNode;

public final class MusicData {
    private final List<List<MusicNode>> nodes;
    private final int offset;
    private final long millsLength;
    private final double tempo;
    private final String name;
    private long tickLength;

    public MusicData(String name, int offset, long tickLength, long millsLength, double tempo) {
        this.name = name;
        this.offset = offset;
        this.tickLength = tickLength;
        this.millsLength = millsLength;
        this.nodes = new ArrayList<List<MusicNode>>((int)tickLength);
        this.tempo = tempo;
    }

    public void addNode(int tick, MusicNode node) {
        while (this.getNodes().size() <= tick) {
            this.getNodes().add(null);
        }
        if (this.getNodes().get(tick) == null) {
            this.getNodes().set(tick, new ArrayList());
        }
        this.getNodes().get(tick).add(node);
        if ((long)tick > this.tickLength) {
            this.tickLength = tick;
        }
    }

    public String getName() {
        return this.name;
    }

    public List<List<MusicNode>> getNodes() {
        return this.nodes;
    }

    public int getOffset() {
        return this.offset;
    }

    public long getTickLength() {
        return this.tickLength;
    }

    public long getMillsLength() {
        return this.millsLength;
    }

    public double getTempo() {
        return this.tempo;
    }
}

