/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.contents.music;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.gb2022.simpnet.util.BufferUtil;
import org.tbstcraft.quark.Quark;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.data.assets.AssetGroup;
import org.tbstcraft.quark.internal.RemoteMessageService;

public interface MusicFileLoader {
    public File load(String var1);

    public Set<String> list();

    default public String random() {
        Set<String> music = this.list();
        int index = SharedObjects.RANDOM.nextInt(music.size());
        return music.toArray(new String[0])[index];
    }

    default public int trim() {
        return 0;
    }

    public static class RemoteLoader
    implements MusicFileLoader {
        private final AssetGroup folder;
        private final String contentServer;

        public RemoteLoader(AssetGroup folder, String contentServer) {
            this.folder = folder;
            this.contentServer = contentServer;
        }

        @Override
        public File load(String name) {
            File file = this.folder.getFile(name);
            RemoteMessageService message = RemoteMessageService.instance();
            if (file.exists() && file.length() > 0L) {
                return this.folder.getFile(name);
            }
            message.query(this.contentServer, "music:get", b -> BufferUtil.writeString((ByteBuf)b, (String)name)).timeout(1250L, () -> {
                throw new RuntimeException("timeout");
            }).result(b -> {
                byte[] buffer = BufferUtil.readArray((ByteBuf)b);
                try {
                    if (file.createNewFile()) {
                        Quark.getInstance().getLogger().info("cached music file %s.".formatted(file.getName()));
                    }
                    FileOutputStream stream = new FileOutputStream(file);
                    stream.write(buffer);
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).request();
            return this.folder.getFile(name);
        }

        @Override
        public Set<String> list() {
            HashSet<String> lists = new HashSet<String>();
            RemoteMessageService.instance().query(this.contentServer, "music:list", (Object)"").result(s -> lists.addAll(List.of(s.split(";")))).timeout(250L, RemoteMessageService.EMPTY_ACTION).request();
            return lists;
        }

        static interface FileChecksum {
            public static File getMD5File(File file) {
                String path = file.getParentFile().getAbsolutePath() + "/.md5/" + file.getName() + ".md5";
                File checksumFile = new File(path);
                if (checksumFile.exists()) {
                    return checksumFile;
                }
                file.getParentFile().mkdirs();
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return checksumFile;
            }

            public static String getMD5Value(File file) {
                File md5File = FileChecksum.getMD5File(file);
                if (md5File.exists() && md5File.length() > 0L) {
                    String string;
                    block9: {
                        String path = md5File.getAbsolutePath();
                        InputStream stream = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
                        try {
                            string = new String(stream.readAllBytes(), StandardCharsets.US_ASCII);
                            if (stream == null) break block9;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                return "_";
                            }
                        }
                        stream.close();
                    }
                    return string;
                }
                String md5 = FileChecksum.calculate(file);
                FileChecksum.write(file, md5);
                return md5;
            }

            public static void write(File file, String md5) {
                File md5File = FileChecksum.getMD5File(file);
                try (FileOutputStream out = new FileOutputStream(md5File);){
                    out.write(md5.getBytes(StandardCharsets.US_ASCII));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public static String calculate(File file) {
                String string;
                block9: {
                    Path path = Paths.get(file.getAbsolutePath(), new String[0]);
                    InputStream stream = Files.newInputStream(path, new OpenOption[0]);
                    try {
                        MessageDigest digest = MessageDigest.getInstance("MD5");
                        byte[] buffer = new byte[4096];
                        while (stream.read(buffer) != -1) {
                            digest.update(buffer);
                        }
                        string = new String(digest.digest(), StandardCharsets.US_ASCII);
                        if (stream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            return "_";
                        }
                    }
                    stream.close();
                }
                return string;
            }
        }
    }

    public static class LocalLoader
    implements MusicFileLoader {
        private final AssetGroup folder;

        public LocalLoader(AssetGroup folder) {
            this.folder = folder;
        }

        @Override
        public File load(String name) {
            if (!this.list().contains(name)) {
                return null;
            }
            return this.folder.getFile(name);
        }

        @Override
        public Set<String> list() {
            return this.folder.list();
        }

        @Override
        public int trim() {
            int count = 0;
            for (File file : Objects.requireNonNull(this.folder.getFolder().listFiles())) {
                String name = file.getName();
                if (!name.contains(" ") || !file.renameTo(new File(this.folder.getFolder(), name.replace(" ", "_")))) continue;
                ++count;
            }
            return count;
        }
    }
}

