/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.contents.music;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import me.gb2022.apm.remote.RemoteMessenger;
import me.gb2022.apm.remote.event.APMRemoteEvent;
import me.gb2022.apm.remote.event.message.RemoteMessageEvent;
import me.gb2022.apm.remote.event.message.RemoteMessageSurpassEvent;
import me.gb2022.apm.remote.event.message.RemoteQueryEvent;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import me.gb2022.commons.reflect.method.MethodHandle;
import me.gb2022.commons.reflect.method.MethodHandleO3;
import me.gb2022.simpnet.util.BufferUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.assertion.NumberLimitation;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.LanguageItem;
import org.atcraftmc.quark.contents.music.EnumInstrument;
import org.atcraftmc.quark.contents.music.MusicData;
import org.atcraftmc.quark.contents.music.MusicFileLoader;
import org.atcraftmc.quark.contents.music.MusicSession;
import org.atcraftmc.quark.contents.music.dispatcher.MusicResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.tbstcraft.quark.Quark;
import org.tbstcraft.quark.data.assets.AssetGroup;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.platform.BukkitUtil;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.framework.module.component.Components;
import org.tbstcraft.quark.framework.module.component.ModuleComponent;
import org.tbstcraft.quark.internal.RemoteMessageService;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.internal.ui.InventoryUI;
import org.tbstcraft.quark.internal.ui.TextRenderer;
import org.tbstcraft.quark.internal.ui.UI;
import org.tbstcraft.quark.internal.ui.providing.GUIProvider;
import org.tbstcraft.quark.internal.ui.view.InventoryUIView;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@CommandProvider(value={MusicCommand.class})
@QuarkModule(version="1.0.3")
@AutoRegister(value={"qb:el", "qb:rm"})
@Components(value={APMEventHandler.class, PlayerEventHandler.class})
public final class MusicPlayer
extends PackageModule {
    public static final String UNSUPPORTED_FORMAT = "unsupported-format";
    public static final String RESOLVE_ERROR = "error-resolving";
    public static final String NOT_FOUND = "not-found";
    public static final String TIMEOUT = "timeout";
    private static final MethodHandleO3<Player, Sound, Float, Float> PLAY_NOTE = (MethodHandleO3)MethodHandle.select(ctx -> {
        ctx.attempt(() -> {
            Class.forName("org.bukkit.SoundCategory");
            return null;
        }, (p, s, power, pitch) -> p.playSound(p.getLocation(), s, SoundCategory.RECORDS, power.floatValue(), pitch.floatValue()));
        ctx.dummy((p, s, power, pitch) -> p.playSound(p.getLocation(), s, power.floatValue(), pitch.floatValue()));
    });
    private final GUIProvider<InventoryUI> musicUI = new MusicUI(this);
    private final MusicSession globalSession = new MusicSession(this);
    private MusicFileLoader loader;
    @Inject(value="music")
    private AssetGroup musicGroup;
    @Inject
    private LanguageEntry language;

    public void enable() {
        if (!this.musicGroup.existFolder()) {
            this.saveDefaults();
        }
        this.globalSession.startSession();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.globalSession.addPlayer(player);
        }
        this.loader = ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"remote") ? new MusicFileLoader.RemoteLoader(this.musicGroup, this.getConfig().value("cdn-server").string()) : new MusicFileLoader.LocalLoader(this.musicGroup);
    }

    public void disable() {
        for (String s : new HashSet(TaskService.async().tasks())) {
            if (!s.startsWith("quark_midi")) continue;
            TaskService.async().cancel(s);
        }
        this.globalSession.stopSession();
    }

    public void saveDefaults() {
        this.musicGroup.save("Avicii-The_Days.mid");
        this.musicGroup.save("Avicii-The_Nights.mid");
        this.musicGroup.save("Avicii-Waiting_For_Love.mid");
        this.musicGroup.save("Kiss_The_Rain.mid");
        this.musicGroup.save("Beyond-\u6d77\u9614\u5929\u7a7a.mid");
    }

    public void pauseMusic(String player) {
        MessageAccessor.broadcast((LanguageEntry)this.language, (boolean)false, (boolean)false, (String)"cancel", (Object[])new Object[]{player});
        this.globalSession.pause();
    }

    public void resumeMusic(String player) {
        MessageAccessor.broadcast((LanguageEntry)this.language, (boolean)false, (boolean)false, (String)"resume", (Object[])new Object[]{player});
        this.globalSession.resume();
    }

    public void cancelMusic(String player) {
        MessageAccessor.broadcast((LanguageEntry)this.language, (boolean)false, (boolean)false, (String)"cancel", (Object[])new Object[]{player});
        this.globalSession.cancel();
    }

    public void playMusic(String player, String music, int pitch, boolean dispatchInstrument, float speedMod, int interpolation) {
        this.globalSession.play(this.select(music, pitch, dispatchInstrument, speedMod, interpolation));
        MessageAccessor.broadcast((LanguageEntry)this.language, (boolean)false, (boolean)false, (String)"play", (Object[])new Object[]{player, music, pitch});
    }

    public void playNode(Set<Player> audience, int node, int off, EnumInstrument targetInstrument, float power) {
        int base = node - 23 + off - 6;
        if (base < 0 || base >= 72) {
            return;
        }
        EnumInstrument remapped = switch (targetInstrument) {
            case EnumInstrument.GUITAR -> {
                if (base > 0) {
                    if (base < 24) {
                        yield EnumInstrument.BASS_GUITAR;
                    }
                    if (base >= 48) {
                        yield EnumInstrument.XYLOPHONE;
                    }
                    yield EnumInstrument.GUITAR;
                }
                yield EnumInstrument.BASS_DRUM;
            }
            case EnumInstrument.PIANO -> {
                if (base > 0) {
                    if (base < 24) {
                        yield EnumInstrument.BASS_GUITAR;
                    }
                    if (base >= 48) {
                        yield EnumInstrument.BELL;
                    }
                    yield EnumInstrument.PIANO;
                }
                yield EnumInstrument.BASS_DRUM;
            }
            case EnumInstrument.STD_DRUM -> {
                switch (node) {
                    case 38: 
                    case 40: {
                        yield EnumInstrument.SNARE_DRUM;
                    }
                    case 42: 
                    case 44: 
                    case 46: 
                    case 49: 
                    case 51: {
                        yield EnumInstrument.HAT;
                    }
                }
                yield EnumInstrument.BASS_DRUM;
            }
            default -> targetInstrument;
        };
        int off1 = base % 12;
        int octave = base % 24 > 11 ? 1 : 0;
        Note n = switch (off1) {
            case 6 -> Note.natural((int)octave, (Note.Tone)Note.Tone.C);
            case 7 -> Note.sharp((int)octave, (Note.Tone)Note.Tone.C);
            case 8 -> Note.natural((int)octave, (Note.Tone)Note.Tone.D);
            case 9 -> Note.sharp((int)octave, (Note.Tone)Note.Tone.D);
            case 10 -> Note.natural((int)octave, (Note.Tone)Note.Tone.E);
            case 11 -> Note.natural((int)octave, (Note.Tone)Note.Tone.F);
            case 0 -> Note.sharp((int)octave, (Note.Tone)Note.Tone.F);
            case 1 -> Note.natural((int)octave, (Note.Tone)Note.Tone.G);
            case 2 -> Note.sharp((int)octave, (Note.Tone)Note.Tone.G);
            case 3 -> Note.natural((int)octave, (Note.Tone)Note.Tone.A);
            case 4 -> Note.sharp((int)octave, (Note.Tone)Note.Tone.A);
            case 5 -> Note.natural((int)octave, (Note.Tone)Note.Tone.B);
            default -> throw new IllegalStateException("Unexpected value: " + off1);
        };
        float pitch = (float)Math.pow(2.0, (double)(n.getId() - 12) / 12.0);
        for (Player p : audience) {
            PLAY_NOTE.invoke((Object)p, (Object)remapped.bukkit(), (Object)Float.valueOf(power), (Object)Float.valueOf(pitch));
        }
    }

    private MusicData select(String name, int pitch, boolean dispatchInstrument, float speedMod, int interpolation) {
        File f = this.loader.load(name);
        if (!f.exists()) {
            throw new IllegalArgumentException(NOT_FOUND);
        }
        return MusicResolver.resolve(f, pitch, dispatchInstrument, speedMod, interpolation);
    }

    public final class MusicUI
    implements GUIProvider<InventoryUI> {
        private final MusicPlayer reference;

        public MusicUI(MusicPlayer reference) {
            this.reference = reference;
        }

        public InventoryUI create() {
            return new InventoryUI(54, TextRenderer.literal((Component)Component.text((String)"__title")));
        }

        public InventoryUIView initializeView(InventoryUI builder, Player viewer, Object ... args) {
            ArrayList<String> list = new ArrayList<String>(this.reference.loader.list());
            list.sort(Comparator.naturalOrder());
            builder.title(TextRenderer.data((LanguageItem)MusicPlayer.this.getLanguage().item("ui-title"), (Object[])new Object[]{list.size() / 45}));
            InventoryUIView view = builder.createInventoryUI(viewer);
            view.setCustomData("music-list", list);
            return view;
        }

        public void render(InventoryUI builder, InventoryUIView view, Object ... args) {
            int page = Integer.parseInt(args[0].toString());
            Boolean legacy = (Boolean)view.getCustomData("legacy", Boolean.class, (Object)false);
            List list = (List)view.getCustomData("music-list", List.class);
            int pages = list.size() / 45;
            int base = page * 45;
            if (page > pages) {
                throw new RuntimeException("Page code out of range!");
            }
            for (int i = base; i < base + 45 && i < list.size(); ++i) {
                String id = (String)list.get(i);
                String name = id.replace(".mid", "").replace(".midi", "").replace("_", " ");
                UI.buildComponent((InventoryUI)builder, (int)(i - base), b -> {
                    ItemStack icon = UI.icon((Material)Material.NOTE_BLOCK);
                    b.icon(icon);
                    b.name(TextRenderer.literal((Component)((TextComponent)Component.text((String)name).decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.AQUA)));
                    b.lore(TextRenderer.literal((Component)Component.text((String)id).decoration(TextDecoration.ITALIC, false)));
                    b.lore(TextRenderer.data((LanguageItem)MusicPlayer.this.getLanguage().item("ui-click"), (Object[])new Object[0]));
                    b.operation(UI.SOUND_CLICK);
                    b.operation(UI.command((Function)UI.value((String)("music play " + id + (legacy != false ? " -legacy" : "")))));
                });
            }
            UI.buildComponent((InventoryUI)builder, (int)45, b -> {
                b.icon(legacy == false ? UI.icon((Material)Material.REDSTONE_TORCH) : UI.enchanted((Material)Material.REDSTONE_TORCH));
                b.name(TextRenderer.data((LanguageItem)(legacy != false ? MusicPlayer.this.getLanguage().item("ui-legacy-control-open") : MusicPlayer.this.getLanguage().item("ui-legacy-control-close")), (Object[])new Object[0]));
                b.operation((v, player, action) -> v.setCustomData("legacy", (Object)(legacy == false ? 1 : 0)));
                b.operation((v, player, action) -> this.rebuildView(v, args));
                b.operation(UI.SOUND_CLICK);
            });
            UI.buildComponent((InventoryUI)builder, (int)53, b -> {
                b.icon(UI.icon((Material)Material.REDSTONE));
                b.name(TextRenderer.data((LanguageItem)Quark.lang().item("common", "ui", "close"), (Object[])new Object[0]));
                b.operation(UI.SOUND_CLICK);
                b.operation(UI.close());
            });
            UI.buildComponent((InventoryUI)builder, (int)52, b -> {
                b.icon(UI.icon((Material)Material.MUSIC_DISC_11));
                b.name(TextRenderer.data((LanguageItem)MusicPlayer.this.getLanguage().item("ui-cancel"), (Object[])new Object[0]));
                b.operation(UI.SOUND_CLICK);
                b.operation(UI.command((Function)UI.value((String)"music cancel")));
            });
            UI.buildComponent((InventoryUI)builder, (int)49, b -> {
                b.icon(UI.icon((Material)Material.CLOCK, (int)(page + 1)));
                b.name(TextRenderer.data((LanguageItem)Quark.lang().item("common", "ui", "page"), (Object[])new Object[]{page + 1, pages + 1}));
            });
            if (page != 0) {
                UI.builder().icon(UI.icon((Material)Material.YELLOW_STAINED_GLASS_PANE)).name(TextRenderer.data((LanguageItem)Quark.lang().item("common", "ui", "prev"), (Object[])new Object[0])).operation((v, player, action) -> v.setData(this.renderData(v, new Object[]{page - 1}))).operation(UI.SOUND_CLICK).build(builder, 48);
            } else {
                UI.builder().icon(UI.icon((Material)Material.GRAY_STAINED_GLASS_PANE)).name(TextRenderer.data((LanguageItem)Quark.lang().item("common", "ui", "prev"), (Object[])new Object[0])).operation(UI.SOUND_DISABLE).build(builder, 48);
            }
            if (page != pages) {
                UI.builder().icon(UI.icon((Material)Material.BLUE_STAINED_GLASS_PANE)).name(TextRenderer.data((LanguageItem)Quark.lang().item("common", "ui", "next"), (Object[])new Object[0])).operation((v, player, action) -> v.setData(this.renderData(v, new Object[]{page + 1}))).operation(UI.SOUND_CLICK).build(builder, 50);
            } else {
                UI.builder().icon(UI.icon((Material)Material.GRAY_STAINED_GLASS_PANE)).name(TextRenderer.data((LanguageItem)Quark.lang().item("common", "ui", "next"), (Object[])new Object[0])).operation(UI.SOUND_DISABLE).build(builder, 50);
            }
        }
    }

    public static final class PlayerEventHandler
    extends ModuleComponent<MusicPlayer> {
        public void enable() {
            BukkitUtil.registerEventListener((Listener)this);
        }

        public void disable() {
            BukkitUtil.unregisterEventListener((Listener)this);
        }

        @EventHandler
        public void onPlayerJoin(PlayerJoinEvent event) {
            ((MusicPlayer)this.parent).globalSession.addPlayer(event.getPlayer());
        }

        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            ((MusicPlayer)this.parent).globalSession.removePlayer(event.getPlayer());
        }
    }

    public static final class APMEventHandler
    extends ModuleComponent<MusicPlayer> {
        public void enable() {
            RemoteMessageService.instance().registerEventHandler((Object)this);
        }

        public void disable() {
            RemoteMessageService.instance().removeMessageHandler((Object)this);
        }

        @APMRemoteEvent(value="music:get")
        public void onMusicFetch(RemoteMessenger ctx, RemoteQueryEvent event) {
            ((MusicPlayer)this.parent).musicGroup.asInputStream(BufferUtil.readString((ByteBuf)event.message()), stream -> event.write(b -> {
                try {
                    BufferUtil.writeArray((ByteBuf)b, (byte[])stream.readAllBytes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
        }

        @APMRemoteEvent(value="music:list")
        public void onMusicList(RemoteMessenger ctx, RemoteQueryEvent event) {
            event.write((Object)String.join((CharSequence)";", ((MusicPlayer)this.parent).musicGroup.list().toArray(new String[0])));
        }

        @APMRemoteEvent(value="music:control")
        public void onMusicEvent(RemoteMessenger ctx, RemoteMessageEvent event) {
            String[] commands = ((String)event.decode(String.class)).split(";");
            switch (commands[0]) {
                case "cancel": {
                    ((MusicPlayer)this.parent).cancelMusic(commands[1]);
                    break;
                }
                case "pause": {
                    ((MusicPlayer)this.parent).pauseMusic(commands[1]);
                    break;
                }
                case "resume": {
                    ((MusicPlayer)this.parent).resumeMusic(commands[1]);
                    break;
                }
                case "play": {
                    String player = commands[1];
                    String music = commands[2];
                    int pitch = Integer.parseInt(commands[3]);
                    float speed = Float.parseFloat(commands[5]);
                    boolean legacy = Boolean.parseBoolean(commands[4]);
                    TaskService.async().run(() -> ((MusicPlayer)this.parent).playMusic(player, music, pitch, legacy, speed, 0));
                }
            }
        }

        @APMRemoteEvent(value="music:control")
        public void onMusicEvent(RemoteMessenger ctx, RemoteMessageSurpassEvent event) {
            this.onMusicEvent(ctx, (RemoteMessageEvent)event);
        }
    }

    @QuarkCommand(name="music", permission="+quark.music.play")
    public static final class MusicCommand
    extends ModuleCommand<MusicPlayer> {
        public void suggest(CommandSuggestion suggestion) {
            suggestion.suggest(0, new String[]{"play", "pause", "resume", "cancel", "gui", "save-defaults", "trim"});
            suggestion.matchArgument(0, "play", ctx -> {
                ctx.suggest(1, ((MusicPlayer)this.getModule()).loader.list());
                ctx.suggest(1, new String[]{"random"});
                for (int i = 2; i < 8; ++i) {
                    ctx.suggest(i, new String[]{"-p:0"});
                    ctx.suggest(i, new String[]{"-p:12"});
                    ctx.suggest(i, new String[]{"-p:-12"});
                    ctx.suggest(i, new String[]{"-s:1"});
                    ctx.suggest(i, new String[]{"-s:1.5"});
                    ctx.suggest(i, new String[]{"-s:0.5"});
                    ctx.suggest(i, new String[]{"-legacy"});
                    ctx.suggest(i, new String[]{"-i:on"});
                    ctx.suggest(i, new String[]{"-i:smart"});
                }
            });
        }

        public void execute(CommandExecution context) {
            RemoteMessageService service = RemoteMessageService.instance();
            String operator = context.getSender().getName();
            switch (context.requireEnum(0, new String[]{"play", "pause", "resume", "cancel", "save-defaults", "gui", "trim"})) {
                case "gui": {
                    int page = context.hasArgumentAt(1) ? context.requireArgumentInteger(1, new NumberLimitation[0]) : 0;
                    ((MusicPlayer)this.getModule()).musicUI.open(context.requireSenderAsPlayer(), new Object[]{page});
                    break;
                }
                case "trim": {
                    this.getLanguage().item("trim").send((Object)context.getSender(), new Object[]{((MusicPlayer)this.getModule()).loader.trim()});
                    break;
                }
                case "save-defaults": {
                    ((MusicPlayer)this.getModule()).saveDefaults();
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)context.getSender(), (String)"restore-defaults", (Object[])new Object[0]);
                    break;
                }
                case "cancel": {
                    ((MusicPlayer)this.getModule()).cancelMusic(operator);
                    service.broadcast("music:control", (Object)("cancel;" + operator));
                    break;
                }
                case "pause": {
                    ((MusicPlayer)this.getModule()).pauseMusic(operator);
                    service.broadcast("music:control", (Object)("pause;" + operator));
                    break;
                }
                case "resume": {
                    ((MusicPlayer)this.getModule()).resumeMusic(operator);
                    service.broadcast("music:control", (Object)("resume;" + operator));
                    break;
                }
                case "play": {
                    String[] args = context.getArgs();
                    int pitch = 0;
                    float speedMod = 1.0f;
                    ConfigurationSection pitchOffsets = this.getConfig().value("pitch-offsets").section();
                    if (pitchOffsets != null && pitchOffsets.contains(args[1])) {
                        pitch = pitchOffsets.getInt(args[1]);
                    }
                    boolean legacy = !List.of(args).contains("-legacy");
                    int interpolation = 0;
                    for (String s : args) {
                        if (s.startsWith("-p:")) {
                            pitch = Integer.parseInt(s.replace("-p:", ""));
                        }
                        if (s.startsWith("-s:")) {
                            speedMod = Float.parseFloat(s.replace("-s:", ""));
                        }
                        if (!s.startsWith("-i:")) continue;
                        interpolation = s.replace("-i:", "").equals("smart") ? 1 : 2;
                    }
                    String music = Objects.equals(args[1], "random") ? ((MusicPlayer)this.getModule()).loader.random() : args[1];
                    if (!((MusicPlayer)this.getModule()).loader.list().contains(music)) {
                        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)context.getSender(), (String)MusicPlayer.NOT_FOUND, (Object[])new Object[]{music});
                        return;
                    }
                    ((MusicPlayer)this.getModule()).playMusic(operator, music, pitch, legacy, speedMod, interpolation);
                    int finalPitch = pitch;
                    float finalSpeedMod = speedMod;
                    service.broadcast("music:control", msg -> {
                        String data = "play;%s;%s;%d;%s;%f".formatted(operator, music, finalPitch, legacy, Float.valueOf(finalSpeedMod));
                        BufferUtil.writeString((ByteBuf)msg, (String)data);
                    });
                }
            }
        }
    }
}

