/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.contents.music;

import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.Language;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.atcraftmc.quark.contents.music.MusicData;
import org.atcraftmc.quark.contents.music.MusicNode;
import org.atcraftmc.quark.contents.music.MusicPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.tbstcraft.quark.PlayerView;
import org.tbstcraft.quark.foundation.TextSender;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.util.PlayerList;

public final class MusicSession
implements Runnable {
    private final MusicPlayer module;
    private final PlayerList players = new PlayerList();
    private final AtomicInteger currentTick = new AtomicInteger(-1);
    private MusicData next;
    private boolean pause = false;
    private boolean cancel = false;
    private boolean active = false;
    private boolean killThread = false;
    private MusicData currentMusic;

    public MusicSession(MusicPlayer module) {
        this.module = module;
    }

    static String formatTime(long mss) {
        DecimalFormat fmt = new DecimalFormat("00");
        long minutes = mss / 60000L;
        long seconds = mss % 60000L / 1000L;
        return fmt.format(minutes) + ":" + fmt.format(seconds);
    }

    private String rendererID() {
        return "quark:music-player:ui@" + this.hashCode();
    }

    @Override
    public void run() {
        while (true) {
            if (this.next == null) {
                try {
                    Thread.sleep(100L);
                    Thread.yield();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            MusicData data = this.next;
            this.next = null;
            if (this.killThread) {
                this.currentMusic = null;
                return;
            }
            this.playSelected(data);
        }
    }

    public void render(Player player) {
        PlayerView.getInstance((Player)player).getActionbar().addChannel(this.rendererID(), 5, 3, TaskService.async(), (a, t) -> {
            if (!this.active) {
                PlayerView.getInstance((Player)a).getActionbar().removeChannel(this.rendererID());
                return;
            }
            if (this.currentMusic == null) {
                PlayerView.getInstance((Player)a).getActionbar().removeChannel(this.rendererID());
                return;
            }
            this.renderUI(a);
        });
    }

    private void renderUI(Player player) {
        if (player == null) {
            return;
        }
        String template = Language.generateTemplate((ConfigEntry)this.module.getConfig(), (String)"ui", (Function[])new Function[]{s -> {
            if (this.pause) {
                s = s.replace("{msg#playing}", "{msg#paused}");
            }
            return s;
        }});
        template = template.replace("{name}", this.currentMusic.getName().replace("_", " ")).replace("{time}", MusicSession.formatTime(this.currentMusic.getMillsLength() * (long)this.currentTick.get() / this.currentMusic.getTickLength())).replace("{total}", MusicSession.formatTime(this.currentMusic.getMillsLength()));
        String ui = this.module.getLanguage().inline(template, LocaleService.locale((CommandSender)player));
        TextSender.sendActionbarTitle((Player)player, (ComponentLike)TextBuilder.build((String)ui, (Component[])new Component[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSelected(MusicData current) {
        boolean isFirstMusicPlayed = false;
        this.players.foreach(this::render);
        this.currentMusic = current;
        this.currentTick.set(0);
        try {
            this.active = true;
            int delayedTicks = 0;
            while ((long)this.currentTick.get() < current.getTickLength() - 1L) {
                if (this.killThread) {
                    this.currentMusic = null;
                    return;
                }
                if (this.cancel) {
                    this.cancel = false;
                    this.currentMusic = null;
                    this.active = false;
                    return;
                }
                while (this.pause) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Thread.yield();
                }
                this.currentTick.incrementAndGet();
                if (current.getNodes().get(this.currentTick.get()) == null) {
                    ++delayedTicks;
                    continue;
                }
                float delayPercentage = (float)delayedTicks / (float)current.getTickLength();
                long delayMilliseconds = current.getTempo() != -1.0 ? (long)(current.getTempo() * (double)delayedTicks) : (long)((float)current.getMillsLength() * delayPercentage);
                try {
                    if (isFirstMusicPlayed) {
                        Thread.sleep(delayMilliseconds);
                    } else {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                delayedTicks = 0;
                for (MusicNode node : current.getNodes().get(this.currentTick.get())) {
                    float power = node.getPower();
                    this.module.playNode(this.players.getPlayerObjects(), node.getNode(), current.getOffset(), node.getInstrument(), power);
                    isFirstMusicPlayed = true;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.currentMusic = null;
            this.active = false;
        }
    }

    public void startSession() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void stopSession() {
        this.killThread = true;
    }

    public void play(MusicData data) {
        if (this.active) {
            this.cancel();
        }
        this.next = data;
    }

    public void pause() {
        this.pause = true;
    }

    public void resume() {
        this.pause = false;
    }

    public void cancel() {
        this.next = null;
        this.cancel = true;
    }

    public void addPlayer(Player player) {
        this.players.add(player);
        if (!this.active) {
            return;
        }
        this.render(player);
    }

    public void removePlayer(Player player) {
        this.players.remove(player);
        if (!this.active) {
            return;
        }
        PlayerView.getInstance((Player)player).getActionbar().removeChannel(this.rendererID());
    }
}

