/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.contents.music.dispatcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import org.atcraftmc.quark.contents.music.EnumInstrument;
import org.atcraftmc.quark.contents.music.InstrumentDecoder;
import org.atcraftmc.quark.contents.music.MusicData;
import org.atcraftmc.quark.contents.music.MusicNode;
import org.atcraftmc.quark.contents.music.dispatcher.MusicDispatcher;

public final class MIDIDispatcher
implements MusicDispatcher {
    public static final int INTERPOLATION_QUALITY = 3;
    public static int KEY_RANGE = 256;

    static MusicData loadMidi(String name, Sequence sequence, int offset, boolean dispatchInstrument, float speedMod, int interpolation) {
        MusicData music = new MusicData(name, offset, sequence.getTickLength(), (long)((float)sequence.getMicrosecondLength() / speedMod) / 1000L, -1.0);
        Track[] tracks = sequence.getTracks();
        InstrumentDecoder decoder = dispatchInstrument ? InstrumentDecoder.modern() : InstrumentDecoder.legacy();
        for (Track track : tracks) {
            EnumInstrument trackInstrument = EnumInstrument.PIANO;
            TrackCache cache = new TrackCache(music);
            for (int i = 0; i < track.size(); ++i) {
                boolean interpolate;
                MidiEvent event = track.get(i);
                MidiMessage message = event.getMessage();
                long time = event.getTick();
                if (!(message instanceof ShortMessage)) continue;
                ShortMessage sm = (ShortMessage)message;
                boolean bl = interpolate = interpolation != 0 && (interpolation != 1 || sm.getChannel() == 0);
                if (sm.getCommand() == 144) {
                    int key = sm.getData1();
                    EnumInstrument instrument = sm.getChannel() == 9 ? EnumInstrument.STD_DRUM : trackInstrument;
                    float power = (float)sm.getData2() / 127.0f;
                    cache.end(key, time, interpolate);
                    cache.set(key, time, power, instrument);
                    continue;
                }
                if (sm.getCommand() == 128) {
                    cache.end(sm.getData1(), time, interpolate);
                    continue;
                }
                if (sm.getCommand() != 192) continue;
                trackInstrument = decoder.dispatch(sm.getData1());
                for (int p = 0; p < KEY_RANGE; ++p) {
                    cache.end(p, time, interpolate);
                }
            }
        }
        return music;
    }

    @Override
    public MusicData load(File file, int offset, boolean remap, float speedMod, int interpolation) {
        try {
            Sequence sequence = MidiSystem.getSequence(new FileInputStream(file));
            String name = file.getName().replace("_", "-");
            return MIDIDispatcher.loadMidi(name, sequence, offset, remap, speedMod, interpolation);
        }
        catch (IOException | InvalidMidiDataException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class TrackCache {
        private final long[] timestamps = new long[KEY_RANGE];
        private final EnumInstrument[] instruments = new EnumInstrument[KEY_RANGE];
        private final float[] powers = new float[KEY_RANGE];
        private final MusicData data;
        private int debug_reportedTasks = -1;

        public TrackCache(MusicData data) {
            this.data = data;
            Arrays.fill(this.timestamps, -1L);
            Arrays.fill((Object[])this.instruments, (Object)EnumInstrument.PIANO);
            Arrays.fill(this.powers, 0.0f);
        }

        public void end(int key, long currentTime, boolean interpolate) {
            if (key < 0 || key >= KEY_RANGE) {
                throw new IllegalArgumentException("key out of range (%s)".formatted(key));
            }
            long timestamp = this.timestamps[key];
            if (timestamp == -1L) {
                return;
            }
            if (!interpolate) {
                this.data.addNode((int)timestamp, new MusicNode(key, this.powers[key], this.instruments[key]));
                this.timestamps[key] = -1L;
                return;
            }
            if (this.debug_reportedTasks > 0) {
                System.out.printf("---[start of %s - %s]---%n", timestamp, currentTime);
            }
            for (long n = timestamp; n <= currentTime; n += 3L) {
                long bt = n - timestamp;
                long dt = currentTime - timestamp;
                float power = this.powers[key] * (1.0f - (float)bt / (float)dt);
                if (power <= 0.0f) continue;
                if (this.debug_reportedTasks > 0) {
                    System.out.printf("%s: %s%n", n, Float.valueOf(power));
                }
                this.data.addNode((int)n, new MusicNode(key, power, this.instruments[key]));
            }
            this.timestamps[key] = -1L;
            if (this.debug_reportedTasks > 0) {
                System.out.printf("---[end]---%n", new Object[0]);
            }
            --this.debug_reportedTasks;
        }

        public void set(int key, long tick, float power, EnumInstrument instrument) {
            if (key < 0 || key >= KEY_RANGE) {
                throw new IllegalArgumentException("key out of range (%s)".formatted(key));
            }
            if (instrument == EnumInstrument.STD_DRUM) {
                this.timestamps[key] = -1L;
                this.data.addNode((int)tick, new MusicNode(key, power, instrument));
                return;
            }
            this.timestamps[key] = tick;
            this.powers[key] = power;
            this.instruments[key] = instrument;
        }
    }
}

