/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.contents.music.dispatcher;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.atcraftmc.quark.contents.music.MusicData;
import org.atcraftmc.quark.contents.music.dispatcher.MIDIDispatcher;
import org.atcraftmc.quark.contents.music.dispatcher.MusicDispatcher;
import org.atcraftmc.quark.contents.music.dispatcher.NBSDispatcher;

public class MusicResolver {
    public static final Map<String, MusicDispatcher> DISPATCHERS = new HashMap<String, MusicDispatcher>();

    static void registerFormat(MusicDispatcher dispatcher, String ... formats) {
        for (String format : formats) {
            DISPATCHERS.put(format, dispatcher);
        }
    }

    public static MusicData resolve(File f, int pitch, boolean dispatchInstrument, float speedMod, int interpolation) {
        String[] names = f.getName().split("\\.");
        MusicDispatcher resolver = DISPATCHERS.get(names[names.length - 1]);
        if (resolver == null) {
            throw new RuntimeException("unsupported-format");
        }
        return resolver.load(f, pitch, dispatchInstrument, speedMod, interpolation);
    }

    static {
        MusicResolver.registerFormat(new MIDIDispatcher(), "mid", "midi");
        MusicResolver.registerFormat(new NBSDispatcher(), "nbs");
    }
}

