/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.contents.music.dispatcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.atcraftmc.quark.contents.music.EnumInstrument;
import org.atcraftmc.quark.contents.music.MusicData;
import org.atcraftmc.quark.contents.music.MusicNode;
import org.atcraftmc.quark.contents.music.dispatcher.MusicDispatcher;

public class NBSDispatcher
implements MusicDispatcher {
    public static MusicData parseNbs(Path path) {
        MusicData musicData;
        block34: {
            String name = path.getFileName().toString();
            String author = "Unknown";
            int currentTick = 0;
            InputStream input = Files.newInputStream(path, new OpenOption[0]);
            try {
                short jump;
                boolean legacy;
                short ticks = NBSDispatcher.readShort(input);
                int version = 0;
                boolean bl = legacy = ticks != 0;
                if (!legacy) {
                    version = input.read();
                    input.skip(1L);
                    ticks = NBSDispatcher.readShort(input);
                }
                input.skip(2L);
                String iname = NBSDispatcher.readString(input);
                String iauthor = NBSDispatcher.readString(input);
                String ioauthor = NBSDispatcher.readString(input);
                NBSDispatcher.readString(input);
                float tempo = (float)NBSDispatcher.readShort(input) / 100.0f;
                if (!iname.isEmpty()) {
                    name = iname;
                }
                if (!ioauthor.isEmpty()) {
                    author = ioauthor;
                } else if (!iauthor.isEmpty()) {
                    author = iauthor;
                }
                input.skip(23L);
                NBSDispatcher.readString(input);
                if (version >= 4) {
                    input.skip(4L);
                }
                MusicData data = new MusicData(author + "-" + name, 0, ticks, (long)((float)ticks * (1000.0f / tempo)), 1000.0f / tempo);
                while ((jump = NBSDispatcher.readShort(input)) != 0) {
                    currentTick += jump + 1;
                    while (NBSDispatcher.readShort(input) != 0) {
                        EnumInstrument instrument = switch (input.read()) {
                            case 1 -> EnumInstrument.BASS_GUITAR;
                            case 2 -> EnumInstrument.BASS_DRUM;
                            case 3 -> EnumInstrument.SNARE_DRUM;
                            case 4 -> EnumInstrument.STICKS;
                            case 5 -> EnumInstrument.GUITAR;
                            case 6 -> EnumInstrument.FLUTE;
                            case 7 -> EnumInstrument.BELL;
                            case 8 -> EnumInstrument.CHIME;
                            case 9 -> EnumInstrument.XYLOPHONE;
                            case 10 -> EnumInstrument.IRON_XYLOPHONE;
                            case 11 -> EnumInstrument.COW_BELL;
                            case 12 -> EnumInstrument.DIDGERIDOO;
                            case 13 -> EnumInstrument.BIT;
                            case 14 -> EnumInstrument.BANJO;
                            case 15 -> EnumInstrument.PLING;
                            default -> EnumInstrument.PIANO;
                        };
                        int key = input.read() + 21;
                        float velocity = 128.0f;
                        if (!legacy) {
                            velocity = input.read();
                            input.read();
                            NBSDispatcher.readShort(input);
                        }
                        MusicNode node = new MusicNode(key, velocity / 128.0f, instrument);
                        data.addNode(currentTick, node);
                    }
                }
                musicData = data;
                if (input == null) break block34;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            input.close();
        }
        return musicData;
    }

    private static short readShort(InputStream input) throws IOException {
        return (short)(input.read() & 0xFF | input.read() << 8);
    }

    private static int readInt(InputStream input) throws IOException {
        return input.read() | input.read() << 8 | input.read() << 16 | input.read() << 24;
    }

    private static String readString(InputStream input) throws IOException {
        return new String(input.readNBytes(NBSDispatcher.readInt(input)));
    }

    @Override
    public MusicData load(File file, int offset, boolean remap, float speedMod, int interpolation) {
        return NBSDispatcher.parseNbs(Path.of(file.toURI()));
    }
}

