/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.storage;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandExecutor;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.command.QuarkCommandExecutor;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule
@CommandProvider(value={DropInsecureUnlockCommand.class})
@AutoRegister(value={"qb:el"})
public final class ItemDropSecure
extends PackageModule
implements QuarkCommandExecutor {
    private final Set<String> unlocks = new HashSet<String>();
    @Inject
    private LanguageEntry language;

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        Item drop = event.getItemDrop();
        Player player = event.getPlayer();
        String id = drop.getItemStack().getType().getKey().toString();
        if (this.unlocks.contains(player.getName())) {
            return;
        }
        if (Arrays.stream(player.getInventory().getStorageContents()).allMatch(Objects::nonNull)) {
            return;
        }
        for (String s : ConfigAccessor.configList((ConfigEntry)this.getConfig(), (String)"list", String.class)) {
            if (!id.contains(s)) continue;
            event.setCancelled(true);
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)player, (String)"warn", (Object[])new Object[0]);
            return;
        }
    }

    public void execute(CommandExecution context) {
        Player player = context.requireSenderAsPlayer();
        int ticks = ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"unlock-time");
        this.unlocks.add(player.getName());
        MessageAccessor.send((LanguageEntry)this.language, (CommandSender)player, (String)"unlock", (Object[])new Object[]{ticks / 20});
        TaskService.global().delay((long)ticks, () -> {
            this.unlocks.remove(player.getName());
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)player, (String)"unlock-end", (Object[])new Object[0]);
        });
    }

    @QuarkCommand(name="unlock-drop", permission="+quark.dropunlock", playerOnly=true)
    public static final class DropInsecureUnlockCommand
    extends ModuleCommand<ItemDropSecure> {
        public void init(ItemDropSecure module) {
            this.setExecutor((CommandExecutor)module);
        }
    }
}

