/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.tweaks;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import me.gb2022.commons.reflect.AutoRegister;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.foundation.platform.BukkitDataAccess;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;

@QuarkModule(version="1.0.0")
@AutoRegister(value={"qb:el"})
public final class CropClickHarvest
extends PackageModule {
    public static final Map<Material, Material> CROPS = new HashMap<Material, Material>();
    public static final double X_RANGE = 0.15;
    public static final double Y_RANGE = 0.35;

    static void processSeedReuses(Collection<ItemStack> items, Material seed) {
        Iterator<ItemStack> it = items.iterator();
        while (it.hasNext()) {
            ItemStack stack = it.next();
            if (stack.getType() != seed) continue;
            stack.setAmount(stack.getAmount() - 1);
            if (stack.getAmount() > 0) continue;
            it.remove();
            return;
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Collection items;
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Block block = event.getClickedBlock();
        Material type = block.getType();
        Random random = SharedObjects.RANDOM;
        if (!CROPS.containsKey(type)) {
            return;
        }
        Ageable data = (Ageable)BukkitDataAccess.blockData((Block)block, Ageable.class);
        Collection collection = items = event.getItem() != null ? block.getDrops(event.getItem(), (Entity)event.getPlayer()) : block.getDrops();
        if (data.getAge() != data.getMaximumAge()) {
            return;
        }
        data.setAge(0);
        block.setBlockData((BlockData)data);
        CropClickHarvest.processSeedReuses(items, CROPS.get(type));
        for (ItemStack stack : items) {
            Location loc = block.getLocation();
            loc.add(random.nextDouble(-0.15, 0.15), random.nextDouble(0.15, 0.35), random.nextDouble(-0.15, 0.15));
            ((Item)block.getWorld().spawnEntity(loc, EntityType.DROPPED_ITEM)).setItemStack(stack);
        }
    }

    static {
        CROPS.put(Material.WHEAT, Material.WHEAT_SEEDS);
        CROPS.put(Material.BEETROOTS, Material.BEETROOT);
        CROPS.put(Material.POTATOES, Material.POTATO);
        CROPS.put(Material.CARROTS, Material.CARROT);
    }
}

