/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.tweaks;

import io.papermc.paper.event.block.BlockPreDispenseEvent;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.language.LanguageItem;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.Directional;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.ItemStack;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.foundation.platform.BukkitDataAccess;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;

@QuarkModule(version="1.0.0")
@AutoRegister(value={"qb:el"})
public final class DispenserBlockPlacer
extends PackageModule {
    @Inject(value="tip")
    private LanguageItem tip;

    public void checkCompatibility() {
        Compatibility.requireClass(() -> Class.forName("io.papermc.paper.event.block.BlockPreDispenseEvent"));
        Compatibility.requirePDC();
    }

    public void enable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tip));
    }

    public void disable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tip));
    }

    @EventHandler
    public void dispenserPlaceBlock(BlockPreDispenseEvent event) {
        Block block = event.getBlock();
        Material type = event.getItemStack().getType();
        Directional data = (Directional)BukkitDataAccess.blockData((Block)block, Directional.class);
        Block face = block.getRelative(data.getFacing());
        if (type.isBlock() && face.getType().isAir()) {
            if (type == Material.TNT) {
                return;
            }
            ItemStack dispensed = ((Dispenser)BukkitDataAccess.blockState((Block)block, Dispenser.class)).getInventory().getItem(event.getSlot());
            if (dispensed != null) {
                dispensed.setAmount(dispensed.getAmount() - 1);
            }
            face.setBlockData(event.getItemStack().getType().createBlockData());
            event.setCancelled(true);
            return;
        }
        if (face.getType().isBlock() && face.isValidTool(event.getItemStack())) {
            event.setCancelled(true);
            face.breakNaturally(event.getItemStack(), true);
        }
    }
}

