/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.tweaks;

import me.gb2022.commons.reflect.AutoRegister;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;

@QuarkModule(version="1.0.0")
@AutoRegister(value={"qb:el"})
public final class DoubleDoorSync
extends PackageModule {
    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null || this.isNotWoodenDoor(clickedBlock.getType())) {
            return;
        }
        this.checkDoors(clickedBlock);
    }

    private void checkDoors(Block dest) {
        Block pair;
        Door data = (Door)dest.getBlockData();
        BlockFace destFace = switch (data.getFacing()) {
            case BlockFace.WEST -> BlockFace.SOUTH;
            case BlockFace.EAST -> BlockFace.NORTH;
            case BlockFace.NORTH -> BlockFace.WEST;
            case BlockFace.SOUTH -> BlockFace.EAST;
            default -> throw new IllegalStateException("Unexpected value: " + data.getFacing());
        };
        if (data.getHinge() == Door.Hinge.LEFT) {
            destFace = destFace.getOppositeFace();
        }
        if (this.isNotWoodenDoor((pair = dest.getRelative(destFace)).getType())) {
            return;
        }
        BlockData blockData = pair.getBlockData();
        if (!(blockData instanceof Door)) {
            return;
        }
        Door pairData = (Door)blockData;
        if (pairData.getHinge() == data.getHinge()) {
            return;
        }
        if (pairData.getHalf() != data.getHalf()) {
            return;
        }
        pairData.setOpen(!data.isOpen());
        pair.setBlockData((BlockData)pairData);
        Block pairHalf = pair.getRelative(pairData.getHalf() == Bisected.Half.BOTTOM ? BlockFace.UP : BlockFace.DOWN);
        Door pairHalfData = (Door)pairHalf.getBlockData();
        pairHalfData.setOpen(!data.isOpen());
        pairHalf.setBlockData((BlockData)pairHalfData);
    }

    private boolean isNotWoodenDoor(Material material) {
        return !material.getKey().getKey().contains("_door");
    }
}

