/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.tweaks;

import java.util.HashSet;
import java.util.Objects;
import me.gb2022.commons.container.MultiMap;
import me.gb2022.commons.reflect.AutoRegister;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;

@QuarkModule(version="0.3", beta=true)
@AutoRegister(value={"qb:el"})
public final class EntityLeash
extends PackageModule {
    public static final String VIRTUAL_ENTITY_ID = "quark:ve:leash";
    private final MultiMap<LivingEntity, LivingEntity> virtualHolders = new MultiMap();
    private final MultiMap<Player, LivingEntity> playerHolders = new MultiMap();

    public void enable() {
        TaskService.async().timer("quark:leash:tick", 2L, 2L, () -> {
            for (Entity e : new HashSet(this.virtualHolders.keySet())) {
                LivingEntity target = (LivingEntity)this.virtualHolders.get((Object)e);
                try {
                    target.teleportAsync(e.getLocation());
                }
                catch (NoSuchMethodError ex) {
                    target.teleport(e.getLocation());
                }
            }
        });
    }

    public void disable() {
        TaskService.async().cancel("quark:leash:tick");
        for (Entity e : new HashSet(this.virtualHolders.keySet())) {
            e.remove();
        }
        this.virtualHolders.clear();
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.getPlayer().isSneaking()) {
            return;
        }
        if (event.getPlayer().getInventory().getItemInMainHand().getType() != Material.LEAD) {
            return;
        }
        this.unleash((LivingEntity)this.playerHolders.get((Object)event.getPlayer()));
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (player.getInventory().getItemInMainHand().getType() != Material.LEAD) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (this.virtualHolders.containsKey((Object)entity2)) {
            return;
        }
        this.leash(entity2, player);
    }

    @EventHandler
    public void onEntityRemove(EntityDeathEvent event) {
        this.unleash((LivingEntity)this.virtualHolders.of((Object)event.getEntity()));
    }

    @EventHandler
    public void onEntityUnleash(EntityUnleashEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity pig = (LivingEntity)entity;
        this.unleash(pig);
    }

    public void unleash(LivingEntity virtual) {
        if (!this.virtualHolders.containsKey((Object)virtual)) {
            return;
        }
        virtual.remove();
        this.playerHolders.remove(this.playerHolders.of((Object)virtual));
        this.virtualHolders.remove((Object)virtual);
    }

    public void leash(LivingEntity target, Player holder) {
        if (this.virtualHolders.containsKey((Object)target)) {
            return;
        }
        Location spawnLocation = target.getLocation();
        Pig pig = (Pig)target.getWorld().spawnEntity(spawnLocation.add(0.5, 0.0, 0.5), EntityType.PIG);
        pig.setInvulnerable(true);
        pig.addScoreboardTag(VIRTUAL_ENTITY_ID);
        pig.setInvisible(true);
        pig.setSilent(true);
        Objects.requireNonNull(pig.getAttribute(Attribute.GENERIC_MAX_HEALTH)).setBaseValue(-1.0);
        this.virtualHolders.put((Object)pig, (Object)target);
        pig.setLeashHolder((Entity)holder);
    }
}

