/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.tweaks;

import java.util.List;
import java.util.Objects;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.LanguageItem;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.2.0")
@CommandProvider(value={FlySpeedCommand.class, FlyToggleCommand.class})
public final class FlySpeedModifier
extends PackageModule {
    @Inject(value="tip")
    private LanguageItem tip;

    public void enable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tip));
    }

    public void disable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tip));
    }

    @QuarkCommand(name="fly", permission="-quark.fly.toggle", playerOnly=true)
    public static final class FlyToggleCommand
    extends ModuleCommand<FlySpeedModifier> {
        public void onCommand(CommandSender sender, String[] args) {
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"toggle", (Object[])new Object[0]);
            Player p = (Player)sender;
            p.setAllowFlight(!p.getAllowFlight());
        }
    }

    @QuarkCommand(name="flyspeed", permission="+quark.fly.flyspeed", playerOnly=true)
    public static final class FlySpeedCommand
    extends ModuleCommand<FlySpeedModifier> {
        public void onCommand(CommandSender sender, String[] args) {
            if (sender instanceof Player) {
                Player p = (Player)sender;
                if (Objects.equals(args[0], "reset")) {
                    p.setFlySpeed(0.125f);
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"cmd-speed-set", (Object[])new Object[]{"0.125"});
                    return;
                }
                float speed = Float.parseFloat(args[0]);
                if (speed < 0.0f || speed > 1.0f) {
                    this.sendExceptionMessage(sender, new Throwable[0]);
                    return;
                }
                p.setFlySpeed(speed);
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"cmd-speed-set", (Object[])new Object[]{Float.toString(speed)});
            }
        }

        public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
            if (buffer.length != 1) {
                return;
            }
            tabList.add("0.0625");
            tabList.add("0.03125");
            tabList.add("0.125");
            tabList.add("0.25");
            tabList.add("0.5");
            tabList.add("1");
            tabList.add("reset");
        }
    }
}

