/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.tweaks;

import java.util.HashMap;
import java.util.Map;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.LanguageItem;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permission;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.foundation.platform.Players;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.PlayerIdentificationService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@AutoRegister(value={"qb:el"})
@QuarkModule(version="1.0.0")
@QuarkCommand(name="freecam", playerOnly=true)
public final class FreeCam
extends CommandModule {
    private final Map<String, GameMode> gameModes = new HashMap<String, GameMode>();
    private final Map<String, Location> locations = new HashMap<String, Location>();
    @Inject(value="tip")
    private LanguageItem tip;
    @Inject(value="-quark.freecam.bypass")
    private Permission bypassPermission;

    public void enable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tip));
        super.enable();
    }

    public void disable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tip));
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.reset(p);
        }
        super.disable();
    }

    public void reset(Player player) {
        String id = PlayerIdentificationService.transformPlayer((Player)player);
        if (!this.gameModes.containsKey(id)) {
            return;
        }
        player.setGameMode(this.gameModes.get(id));
        Players.teleport((Entity)player, (Location)this.locations.get(id));
        this.gameModes.remove(id);
        this.locations.remove(id);
        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)player, (String)"reset", (Object[])new Object[0]);
    }

    public void start(Player player) {
        String id = PlayerIdentificationService.transformPlayer((Player)player);
        if (this.gameModes.containsKey(id)) {
            return;
        }
        this.locations.put(id, player.getLocation());
        this.gameModes.put(id, player.getGameMode());
        player.setGameMode(GameMode.SPECTATOR);
        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)player, (String)"start", (Object[])new Object[0]);
    }

    public void toggle(Player p) {
        if (this.gameModes.containsKey(PlayerIdentificationService.transformPlayer((Player)p))) {
            this.reset(p);
        } else {
            this.start(p);
        }
    }

    private boolean inSession(Player p) {
        return this.gameModes.containsKey(PlayerIdentificationService.transformPlayer((Player)p));
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.reset(event.getPlayer());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        event.getPlayer().setGameMode(Bukkit.getDefaultGameMode());
    }

    public void onCommand(CommandSender sender, String[] args) {
        this.toggle((Player)sender);
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (event.getMessage().contains("freecam")) {
            return;
        }
        if (!ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"anti-cheat")) {
            return;
        }
        if (event.getPlayer().hasPermission(this.bypassPermission)) {
            return;
        }
        if (this.inSession(event.getPlayer())) {
            event.setCancelled(true);
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)event.getPlayer(), (String)"anti-cheat", (Object[])new Object[0]);
        }
    }
}

