/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.tweaks;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.gb2022.commons.math.MathHelper;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.LanguageItem;
import org.atcraftmc.qlib.task.TaskScheduler;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.platform.APIProfile;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;
import org.tbstcraft.quark.util.TaskHandle;

@AutoRegister(value={"qb:el"})
@QuarkModule(beta=true, compatBlackList={APIProfile.ARCLIGHT, APIProfile.BUKKIT, APIProfile.BUKKIT})
@CommandProvider(value={LeaveBedCommand.class})
public final class RealisticSleep
extends PackageModule {
    private final Map<World, Set<Player>> sleepingPlayers = new HashMap<World, Set<Player>>();
    private final Set<Player> daySleepingPlayers = new HashSet<Player>();
    private final Set<Player> whateverSleepingPlayers = new HashSet<Player>();
    private final TaskHandle daemonTask = TaskHandle.timer((TaskScheduler)TaskService.global(), (String)"quark:rs:daemon", (int)1, (int)1, () -> {
        for (World w : Bukkit.getWorlds()) {
            if (w.isDayTime()) continue;
            if (!this.sleepingPlayers.containsKey(w)) {
                this.sleepingPlayers.put(w, new HashSet());
            }
            w.setTime((long)((float)w.getTime() + (float)this.sleepingPlayers.get(w).size() * ConfigAccessor.getFloat((ConfigEntry)this.getConfig(), (String)"scale-per-player")));
        }
    });
    @Inject(value="tip")
    private LanguageItem tip;

    public void enable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tip));
        TaskService.global().timer("quark:rs:health", 1L, (long)ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"health-interval"), () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!this.whateverSleepingPlayers.contains(p)) continue;
                double health = p.getHealth() + (double)ConfigAccessor.getFloat((ConfigEntry)this.getConfig(), (String)"health-amount");
                double max = Objects.requireNonNull(p.getAttribute(Attribute.GENERIC_MAX_HEALTH)).getValue();
                p.setHealth(MathHelper.clamp((double)health, (double)0.0, (double)max));
            }
        });
        this.daemonTask.start();
    }

    public void disable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tip));
        TaskService.global().cancel("quark:rs:health");
        this.daemonTask.stop();
    }

    private Set<Player> getPlayerList(Player p) {
        if (!this.sleepingPlayers.containsKey(p.getWorld())) {
            this.sleepingPlayers.put(p.getWorld(), new HashSet());
        }
        return this.sleepingPlayers.get(p.getWorld());
    }

    @EventHandler
    public void onPlayerSleep(PlayerBedEnterEvent event) {
        event.setUseBed(Event.Result.ALLOW);
        this.whateverSleepingPlayers.add(event.getPlayer());
        if (event.getPlayer().getWorld().isDayTime()) {
            this.daySleepingPlayers.add(event.getPlayer());
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)event.getPlayer(), (String)"sleep-day", (Object[])new Object[0]);
            return;
        }
        this.getPlayerList(event.getPlayer()).add(event.getPlayer());
    }

    @EventHandler
    public void onPlayerLeftBed(PlayerBedLeaveEvent event) {
        if (event.getPlayer().getWorld().isDayTime()) {
            if (!this.daySleepingPlayers.contains(event.getPlayer())) {
                this.whateverSleepingPlayers.remove(event.getPlayer());
                return;
            }
            event.setCancelled(true);
            return;
        }
        this.whateverSleepingPlayers.remove(event.getPlayer());
        this.getPlayerList(event.getPlayer()).remove(event.getPlayer());
    }

    @QuarkCommand(name="leave-bed", permission="+quark.bed.leave", playerOnly=true, aliases={"wakeup", "leave"})
    public static final class LeaveBedCommand
    extends ModuleCommand<RealisticSleep> {
        public void onCommand(CommandSender sender, String[] args) {
            ((RealisticSleep)this.getModule()).daySleepingPlayers.remove((Player)sender);
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"leave-bed", (Object[])new Object[0]);
        }
    }
}

