/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.tweaks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageItem;
import org.bukkit.Axis;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Orientable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.ConfigAccessor;

@AutoRegister(value={"qb:el"})
@QuarkModule(id="vein_miner")
public final class VeinMiner
extends PackageModule {
    private final Set<String> breakingSession = new HashSet<String>();
    @Inject(value="tip")
    private LanguageItem tip;
    private Pattern pattern;

    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requireMethod(() -> Material.class.getMethod("getKey", new Class[0]));
    }

    public void enable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tip));
        this.pattern = this.getConfig().value("regex").getRegex();
    }

    public void disable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tip));
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.breakingSession.contains(event.getPlayer().getName())) {
            return;
        }
        if (!event.getPlayer().isSneaking()) {
            return;
        }
        if (event.getPlayer().getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        String id = event.getBlock().getType().getKey().getKey();
        if (this.canNotChainMine(id)) {
            return;
        }
        event.setCancelled(true);
        this.breakingSession.add(event.getPlayer().getName());
        this.mineBlockAt(event.getPlayer(), event.getBlock().getType(), event.getBlock(), 0);
        this.breakingSession.remove(event.getPlayer().getName());
    }

    private boolean canNotChainMine(String id) {
        return !this.pattern.matcher(id).find() || id.contains("stripped");
    }

    private void mineBlockAt(Player player, Material origin, Block block, int currentDeep) {
        if (this.canNotChainMine(block.getType().getKey().getKey())) {
            return;
        }
        if (block.getType() != origin) {
            return;
        }
        if (currentDeep >= ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"max-iterations")) {
            return;
        }
        player.breakBlock(block);
        for (Block b : this.getAdjacentBlocks(block)) {
            this.mineBlockAt(player, origin, b, currentDeep + 1);
        }
    }

    private boolean testBlock(Block mining, Block original) {
        Material material = mining.getType();
        String id = material.getKey().getKey();
        if (id.contains("_ore")) {
            return mining.getType() == original.getType();
        }
        if (id.contains("_log")) {
            Axis origin = ((Orientable)original.getBlockData()).getAxis();
            Axis current = ((Orientable)mining.getBlockData()).getAxis();
            return mining.getType() == original.getType() && origin == current;
        }
        return false;
    }

    private List<Block> getAdjacentBlocks(Block block) {
        ArrayList<Block> adjacentBlocks = new ArrayList<Block>();
        World world = block.getWorld();
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    if (xOffset == 0 && yOffset == 0 && zOffset == 0) continue;
                    Block relativeBlock = world.getBlockAt(x + xOffset, y + yOffset, z + zOffset);
                    adjacentBlocks.add(relativeBlock);
                }
            }
        }
        return adjacentBlocks;
    }
}

