/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.warps;

import java.util.HashMap;
import java.util.Map;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandExecutor;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.LanguageItem;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.command.QuarkCommandExecutor;
import org.tbstcraft.quark.foundation.platform.Players;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.MessageAccessor;
import org.tbstcraft.quark.util.BukkitSound;

@QuarkModule(version="1.3.0")
@AutoRegister(value={"qb:el"})
@CommandProvider(value={BackCommand.class})
public final class BackToDeath
extends PackageModule
implements QuarkCommandExecutor {
    private final Map<String, Location> deathPoints = new HashMap<String, Location>();
    @Inject(value="tip-back")
    private LanguageItem tipBack;

    public void enable() {
        super.enable();
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tipBack));
    }

    public void disable() {
        super.disable();
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tipBack));
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        if (!this.deathPoints.containsKey(event.getPlayer().getName())) {
            return;
        }
        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)event.getPlayer(), (String)"back-hint", (Object[])new Object[0]);
    }

    @EventHandler
    public void onPlayerDie(PlayerDeathEvent event) {
        Player player = event.getEntity();
        this.deathPoints.put(player.getName(), player.getLocation());
    }

    public void execute(CommandExecution context) {
        CommandSender sender = context.getSender();
        if (!this.deathPoints.containsKey(sender.getName())) {
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"back-not-set", (Object[])new Object[0]);
            return;
        }
        Players.teleport((Entity)((Player)sender), (Location)this.deathPoints.get(sender.getName()));
        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"back-tp-success", (Object[])new Object[0]);
        BukkitSound.WARP.play((Player)sender);
    }

    @QuarkCommand(name="back", playerOnly=true, permission="+quark.warp.back")
    public static final class BackCommand
    extends ModuleCommand<BackToDeath> {
        public void init(BackToDeath module) {
            this.setExecutor((CommandExecutor)module);
        }
    }
}

